#ifndef _EditImage_EditImage_h
#define _EditImage_EditImage_h


#include <CtrlLib/CtrlLib.h>


#include <GridCtrl/GridCtrl.h>

using namespace Upp;

Image PropRescale(const Image& im, const Size res_size);
Image PropRescale(const Image& im, const int cx, const int cy);
Image PropRescale(const Image& im, const ImageCtrl& imc);
void  PropRescale(const Image& im, ImageCtrl& imc ,const bool setimage);

struct ImageBtn : public ImageCtrl {
	typedef ImageBtn CLASSNAME;
	bool norepaint;
	ImageBtn() 						{ IgnoreMouse(false); norepaint=false; }
	void NoRepaint()									{ norepaint=true; }
	virtual void LeftDown(Point p, dword keyflags) 		{ Action(); }
	virtual void MouseEnter(Point p, dword keyflags) 	{ Refresh(); }
	virtual void MouseLeave() 				{ Refresh(); }
	
	virtual void Paint(Draw& draw) { 
		if (HasMouse() && !norepaint) 
			draw.DrawRect(GetSize(), SColorHighlight());
		ImageCtrl::Paint(draw);
	}		
};

#include <EditImage/view_image.h>

class EditImage : public ImageBtn {
private:
	ToolBar imagebar;
	Color bg;
	Size storeddimension;
	virtual void DragAndDrop(Point p, PasteClip& d);
	void SaveImage();
	void ViewImage();
	void EraseImage();
	void PasteImage();
	void SaveToFileImage();
	Size defaultviewsz;
	
	
public:
	typedef EditImage CLASSNAME;
	EditImage();
	Image image;
	String ToString();
	void FromString(String s);
	
	void SetBackground(Color c) {bg = c;}
	EditImage& Background(Color c) {bg = c; return *this;} 
	void SetStoredDimension(Size sz) {storeddimension = sz;}
	
	EditImage& DefaultViewWindowSize(Size sz) {defaultviewsz = sz; return *this;} 
	virtual void Paint(Draw& draw);		

};


#endif

