/*
*
* License: BSD
* Author: Sergey Sikorskiy
*
*/

#ifndef PYTHONPP_DATE_H
#define PYTHONPP_DATE_H

#include "PythonPP_object.h"
#include <datetime.h>

NAMESPACE_UPP

namespace pythonpp
{

class CTimeDelta : public Object
{
public:
	CTimeDelta(int days, int seconds, int useconds)
	: Object(PyDelta_FromDSU(days, seconds, useconds), eTakeOwnership)
	{
	}

protected:
	static bool HasSameType(PyObject* obj)
	{
		return PyDelta_Check(obj);
	}
	static bool HasExactSameType(PyObject* obj)
	{
		return PyDelta_CheckExact(obj);
	}

private:
};

class CTZInfo : public Object
{
public:
protected:
	static bool HasSameType(PyObject* obj)
	{
		return PyTZInfo_Check(obj);
	}
	static bool HasExactSameType(PyObject* obj)
	{
		return PyTZInfo_CheckExact(obj);
	}

private:
};

class CTime : public Object
{
public:
	CTime(PyObject* obj, EOwnership ownership = eAcquireOwnership)
	: Object(obj, ownership)
	{
		if (!HasExactSameType(obj)) {
			throw CTypeError("Invalid conversion");
		}
	}
	CTime(const Object& obj)
	{
		if (!HasExactSameType(obj)) {
			throw CTypeError("Invalid conversion");
		}
		Set(obj);
	}
	CTime(int hour, int minute, int second, int usecond)
	: Object(PyTime_FromTime(hour, minute, second, usecond), eTakeOwnership)
	{
	}

public:
	int GetHour(void) const
	{
		return PyDateTime_TIME_GET_HOUR(Get());
	}
	int GetMinute(void) const
	{
		return PyDateTime_TIME_GET_MINUTE(Get());
	}
	int GetSecond(void) const
	{
		return PyDateTime_TIME_GET_SECOND(Get());
	}
	int GetMicroSecond(void) const
	{
		return PyDateTime_TIME_GET_MICROSECOND(Get());
	}

public:
	static bool HasSameType(PyObject* obj)
	{
		return PyTime_Check(obj);
	}
	static bool HasExactSameType(PyObject* obj)
	{
		return PyTime_CheckExact(obj);
	}

private:
};

class CDate : public Object
{
// PyObject* PyDate_FromTimestamp(PyObject *args)
public:
	CDate(PyObject* obj, EOwnership ownership = eAcquireOwnership)
	: Object(obj, ownership)
	{
	}
	CDate(const Object& obj)
	: Object(obj)
	{
	}
	CDate(int year, int month, int day)
	: Object(PyDate_FromDate(year, month, day), eTakeOwnership)
	{
	}

public:
	int GetYear(void) const
	{
		return PyDateTime_GET_YEAR(Get());
	}
	int GetMonth(void) const
	{
		return PyDateTime_GET_MONTH(Get());
	}
	int GetDay(void) const
	{
		return PyDateTime_GET_DAY(Get());
	}

public:
	static bool HasSameType(PyObject* obj)
	{
		return PyDate_Check(obj);
	}
	static bool HasExactSameType(PyObject* obj)
	{
		return PyDate_CheckExact(obj);
	}

private:
};

class CDateTime : public CDate
{
// PyObject* PyDateTime_FromTimestamp(PyObject *args)

public:
	CDateTime(PyObject* obj, EOwnership ownership = eAcquireOwnership)
	: CDate(obj, ownership)
	{
		if (!HasExactSameType(obj)) {
			throw CTypeError("Invalid conversion");
		}
	}
	CDateTime(const Object& obj)
	: CDate(obj)
	{
		if (!HasExactSameType(obj)) {
			throw CTypeError("Invalid conversion");
		}
		Set(obj);
	}
	CDateTime(int year, int month, int day, int hour = 0, int minute = 0, int second = 0, int usecond = 0)
	: CDate(PyDateTime_FromDateAndTime(year, month, day, hour, minute, second, usecond), eTakeOwnership)
	{
	}

public:
	int GetHour(void) const
	{
		return PyDateTime_DATE_GET_HOUR(Get());
	}
	int GetMinute(void) const
	{
		return PyDateTime_DATE_GET_MINUTE(Get());
	}
	int GetSecond(void) const
	{
		return PyDateTime_DATE_GET_SECOND(Get());
	}
	int GetMicroSecond(void) const
	{
		return PyDateTime_DATE_GET_MICROSECOND(Get());
	}

public:
	static bool HasSameType(PyObject* obj)
	{
		return PyDateTime_Check(obj);
	}
	static bool HasExactSameType(PyObject* obj)
	{
		return PyDateTime_CheckExact(obj);
	}

private:
};

}

END_UPP_NAMESPACE

#endif                                  // PYTHONPP_DATE_H

