#include "PythonPP_emb.h"

NAMESPACE_UPP

namespace pythonpp
{

//////////////////////////////////////////////////////////////////////////
Engine::Engine(const char* prog_name)
{
	if (prog_name) {
		Py_SetProgramName(const_cast<char*>(prog_name));
	}

	// Initialize the Python interpreter.  Required.
	Py_Initialize();
}

Engine::Engine(int argc, char *argv[])
{
	// Pass argv[0] to the Python interpreter
	Py_SetProgramName(argv[0]);

	// Initialize the Python interpreter.  Required.
	Py_Initialize();

	// Define sys.argv.  It is up to the application if you
	// want this; you can also let it undefined (since the Python
	// code is generally not a main program it has no business
	// touching sys.argv...)
	PySys_SetArgv(argc, argv);
}

Engine::~Engine()
{
	// Exit, cleaning up the interpreter
	Py_Finalize();
}

void Engine::ExecuteStr(const char* cmd)
{
	if (PyRun_SimpleString(cmd) == -1) {
		// throw CError ("Unable to execute a String");
		throw String("Couldn't execute string '") + cmd + "'";
	}
}

void Engine::ExecuteFile(const char* file_name)
{
	FILE* file = NULL;
	file = fopen(file_name, "r");
	if (file != NULL) {
		// PyRun_AnyFileEx will close the file after execution ...
		if (PyRun_AnyFileEx(file, file_name, 1) == -1) {
			// throw CError ("Unable to execute a file");
			throw String("Couldn't execute file '") + file_name + "'";
		}
	}
}

}

END_UPP_NAMESPACE

