#include "PythonPP_ext.h"

NAMESPACE_UPP

namespace pythonpp
{
//////////////////////////////////////////////////////////////////////////
MethodDef::MethodDef()
{
	ml_name = 0;
	ml_meth = 0;
	ml_flags = 0;
	ml_doc = 0;
}

MethodDef::MethodDef(const char* name, PyCFunction func, int flags, const char* doc)
{
	ml_name = const_cast<char*>(name);
	ml_meth = func;
	ml_flags = flags;
	ml_doc = const_cast<char*>(doc);
}

MethodDef::MethodDef(const MethodDef& other)
{
	ml_name = other.ml_name;
	ml_meth = other.ml_meth;
	ml_flags = other.ml_flags;
	ml_doc = other.ml_doc;
}

MethodDef& MethodDef::operator = (const MethodDef& other)
{
	if (this != &other) {
		ml_name = other.ml_name;
		ml_meth = other.ml_meth;
		ml_flags = other.ml_flags;
		ml_doc = other.ml_doc;
	}
	return *this;
}

//////////////////////////////////////////////////////////////////////////
extern "C"
void standard_dealloc(PyObject* obj)
{
	PyMem_DEL(obj);
}

//////////////////////////////////////////////////////////////////////////
ExtType::ExtType(
	size_t basic_size,
	destructor dr,
	PyTypeObject* base
	)
{
	BasicInit();

	ob_type = &PyType_Type;
	tp_basicsize = basic_size;
	tp_dealloc = dr;
	// Py_TPFLAGS_BASETYPE - means that the type is subtypable ...
	tp_flags = Py_TPFLAGS_DEFAULT;
	tp_base = base;
	// tp_bases = ??? // It should be NULL for statically defined types.

	// Finalize the type object including setting type of the new type
	// object; doing it here is required for portability to Windows
	// without requiring C++.
	// !!! This code does not work currently !!!
	// if ( PyType_Ready(this) == -1 ) {
	//     throw CError("Cannot initialyze a type object");
	// }
}

void ExtType::BasicInit()
{
#ifdef Py_TRACE_REFS
	_ob_next = NULL;
	_ob_prev = NULL;
#endif
	ob_refcnt = 1;
	ob_type = NULL;

	ob_size = 0;

	tp_name = NULL;

	tp_basicsize = 0;
	tp_itemsize = 0;

	// Methods to implement standard operations
	tp_dealloc = NULL;
	tp_print = NULL;

	tp_getattr = NULL;              // This field is deprecated.
	tp_setattr = NULL;              // This field is deprecated.

	tp_compare = NULL;
	tp_repr = NULL;

	// Method suites for standard classes
	tp_as_number = NULL;
	tp_as_sequence = NULL;
	tp_as_mapping =  NULL;

	// More standard operations (here for binary compatibility)
	tp_hash = NULL;
	tp_call = NULL;
	tp_str = NULL;

	tp_getattro = NULL;
	tp_setattro = NULL;

	// Functions to access object as input/output buffer
	tp_as_buffer = NULL;

	// Flags to define presence of optional/expanded features
	tp_flags = 0L;

	// Documentation string
	tp_doc = NULL;

	// call function for all accessible objects
	tp_traverse = 0L;

	// delete references to contained objects
	tp_clear = 0L;

	// rich comparisons
	tp_richcompare = 0L;

	// weak reference enabler
	tp_weaklistoffset = 0L;

	// Iterators
	tp_iter = 0L;
	tp_iternext = 0L;

	// Attribute descriptor and subclassing stuff
	tp_methods = NULL;  // Object's method table ( same as retturned by GetMethodHndlList() )
	tp_members = NULL;
	tp_getset = NULL;
	tp_base = NULL;

	tp_dict = NULL;
	tp_descr_get = NULL;
	tp_descr_set = NULL;

	tp_dictoffset = 0;

	tp_init = NULL;
	tp_alloc = NULL;
	tp_new = NULL;
	tp_free = NULL; // Low-level free-memory routine
	tp_is_gc = NULL; // For PyObject_IS_GC
	tp_bases = NULL;
	tp_mro = NULL; // method resolution order
	tp_cache = NULL;
	tp_subclasses = NULL;
	tp_weaklist = NULL;
	tp_del = NULL;

#ifdef COUNT_ALLOCS
	tp_alloc = 0;
	tp_free = 0;
	tp_maxalloc = 0;
	tp_next = 0;
#endif
}

//////////////////////////////////////////////////////////////////////////
String ModuleExt::m_Name;
PyObject* ModuleExt::m_Module = NULL;

void
ModuleExt::Declare(const String& name, PyMethodDef* methods)
{
	ASSERT(m_Module == NULL);

	m_Name = name;
	m_Module = Py_InitModule(const_cast<char*>(~name), methods);
	Error::Check(m_Module);
}

void
ModuleExt::AddConstValue(const String& name, PyObject* value)
{
	Error::Check(value);
	if (PyModule_AddObject(m_Module, const_cast<char*>(~name), value) == -1) {
		throw SystemError("Failed to add a constant value to a module");
	}
}

void
ModuleExt::AddConst(const String& name, const String& value)
{
	PyObject* py_value = PyString_FromString(~value);
	Error::Check(py_value);
	AddConstValue(name, py_value);
}

void
ModuleExt::AddConst(const String& name, long value)
{
	PyObject* py_value = PyLong_FromLong(value);
	Error::Check(py_value);
	AddConstValue(name, py_value);
}


}

END_UPP_NAMESPACE

