#include "SlideSw.h"

#define			BORDER_SIZE			5
#define			BORDER1				BORDER_SIZE
#define			BORDER2				( 2 * BORDER_SIZE )

#define IMAGECLASS SlideSwImg
#define IMAGEFILE <JFControls/SlideSw.iml>
#include <Draw/iml.h>

SlideSw::SlideSw()
: mFillColor(LtCyan())
, m_Pos(0)
, mSlideSwType(CONTROL)
{
	Vector<String> v;
	v.Add("0");
	v.Add("1");
	v.Add("2");
	SetPos( 0 );		// set the thumb to zero position
	Transparent();		// make the control transparent
	NoWantFocus();		// Do not want focus at this time
}

// Check if the slider is vertically oriented
bool SlideSw::IsVert() const
{
	return GetSize().cx < GetSize().cy;
}

// return x for Hslider or y for Vslider
int  SlideSw::HoVe(int  x, int  y) const
{
	return IsVert() ? y : x;
}

// return &x for Hslider or &y for Vslider
int& SlideSw::HoVeR(int& x, int& y) const
{
	return IsVert() ? y : x;
}

// Draw the slider on the canvas w
void SlideSw::Paint(Draw& w)
{
	Size size = GetSize();

	// set up the parameters for drawing the slider
	if(IsVert())	Full = size.cx;
	else			Full = size.cy;
	Half  = Full/2;
	Quart = Half/2;
	Eighth = Quart/2;
	
	// draw gradations
	for( 	int i = 0; i < m_vValues.GetCount(); i++ ) 
	{
		// draw ticks as defined
		DrawTick( w, (HOVE)HoVe( HORZ, VERT ),  i );
	}

	if(IsVert()) 
	{   // Vertical slider

		// Draw a frame for the fill
		DrawBorder(w, Half+Quart, BORDER1,
					  Quart, size.cy - BORDER2,
					  BlackBorder());
		// draw the fill where bottom is the min value
		w.DrawRect(Half+Quart+1, SliderToClient(m_Pos)+1,
				   Quart-2, size.cy-SliderToClient(m_Pos)-BORDER1-2,
				   mFillColor);

		// show the Thumb only if the slider is a CONTROL
		if (mSlideSwType == CONTROL)
		{
			// Draw thumbs for each set of data
			w.DrawImage(
	/*x*/	Half+Quart ,
	/*y*/	SliderToClient(m_Pos) - Eighth,
	/*cx*/	Quart,
	/*cy*/	Quart,
			HasCapture() || HasFocus() ? CtrlsImg::kLA() : CtrlsImg::kLA() 
			);
		}
	}
	else 
	{ 	// Draw Line Border, L T R B
		DrawBorder(w, BORDER1, Half+Quart, size.cx-BORDER2, Quart, BlackBorder);
		w.DrawRect(BORDER1+1, Half+Quart+1, SliderToClient(m_Pos)-2, Quart-2, mFillColor);
		
		// draw thumbs
		if (mSlideSwType == CONTROL)
		{
			w.DrawImage(
	/*x*/	SliderToClient(m_Pos),
	/*y*/	Half+Quart ,
	/*cx*/	Quart,
	/*cy*/	Quart,
		    HasCapture() || HasFocus() ? CtrlsImg::kUA() : CtrlsImg::kUA());
		}
	}
	if(HasFocus())		DrawFocus(w, size);
}


// draw a tickmark at Switch Pos
void	SlideSw::DrawTick( Draw &w, HOVE Orientation, int Pos )
{
	Size size = GetSize();
	Size sz = GetTextSize( m_vValues[Pos], StdFont() );
	int	 wPos = SliderToClient(Pos);

	if( Orientation == HORZ ) 
	{
		w.DrawLine(	wPos+BORDER1, Half, 
					wPos+BORDER1, Half+Quart,
					1 );
			
		int nTextPos = wPos - (int)( sz.cx / 2.0f + 0.5f );
		nTextPos = min( max( 0, nTextPos ), size.cx - sz.cx );
		w.DrawText( nTextPos, 0, m_vValues[Pos] );
	}
	else
	{// vert
		w.DrawLine( Half, 		wPos, 
					Half+Quart, wPos,
					1 );
		
		int nTextPos = wPos - (int)( sz.cy / 2.0f + 0.5f );
		nTextPos = min( max( 0, nTextPos ), size.cy - sz.cy );
		w.DrawText( 0, nTextPos, m_vValues[Pos] );
	}
}

// handle keys addressed to the slider (GotFocussed)
// only if it is a CONTROL
bool SlideSw::Key(dword key, int repcnt)
{
	// No thumb action for indicator
	if (mSlideSwType == INDICATOR)	return Ctrl::Key(key, repcnt);

	if(IsEditable())
		switch(key) {
		case K_LEFT:
		case K_UP:
			if (m_Pos < m_vValues.GetCount()-1)	m_Pos++;
			return true;
		case K_RIGHT:
		case K_DOWN:
			if (m_Pos)							m_Pos--;
			return true;
		}
	return Ctrl::Key(key, repcnt);
}

// handle the left mouse button if the slider is s CONTROL
void SlideSw::LeftDown(Point pos, dword keyflags)
{
	if(!IsEditable())  return;
	
	// No thumb action for indicator
	if (mSlideSwType == INDICATOR)	return;
	
	SetWantFocus();
	
	int thumbPos = SliderToClient(m_Pos);
	int p = HoVe(pos.x, pos.y);
	int nHalfThumb = HoVe(SlideSwImg::ThumbH().GetSize().cx, SlideSwImg::ThumbV().GetSize().cy) >> 1;
			 
	if(IsNull(thumbPos)) {
		SetPos( ClientToSlider(p) );
		if (WhenSlideFinish)
			WhenSlideFinish();
		UpdateActionRefresh();
	}
	// Did we click on the thumb?
	else if( ( p >= ( thumbPos - nHalfThumb ) ) && 
		( p < ( thumbPos + nHalfThumb ) ) )
		SetCapture();
	else 
	{	// on either side of the thumb position, let the slider Inc or Dec
		if(   p < thumbPos)
			if (IsVert())	Inc(); else Dec();
		else
			if (IsVert())	Dec(); else Inc();
	}
	
	Refresh();
}

void SlideSw::LeftRepeat(Point p, dword f)
{
	if(!HasCapture())
		LeftDown(p, f);
}

void SlideSw::LeftUp(Point pos, dword keyflags)
{
	if (HasCapture())
		if (WhenSlideFinish)
			WhenSlideFinish();
	Refresh();
}

void SlideSw::MouseMove(Point pos, dword keyflags)
{
	if(HasCapture()) 
	{
		// for vertical slider, make the bottom end min
		int n = ClientToSlider(HoVe(pos.x, GetSize().cy-pos.y));
		SetPos( n );
		UpdateActionRefresh();
	}
}

// CONVERT SLIDER VALUES TO Canvas coordinates
int SlideSw::SliderToClient(int Pos) const
{
	if(IsNull(Pos))		return Null;
	
	Size size = GetSize();

	// restrict to range of SlideSw values
	Pos = minmax(Pos, 0, m_vValues.GetCount()-1);

	Pos = iscaleceil(Pos, HoVe(size.cx, size.cy)-BORDER2, m_vValues.GetCount()-1);
	
	if (IsVert())	Pos = (size.cy)-Pos-BORDER1;
	return Pos;
}

// convert canvas coordinates to slider value
int SlideSw::ClientToSlider(int p) const
{
	return minmax(iscale(p-BORDER1, m_vValues.GetCount()-1, HoVe(GetSize().cx , GetSize().cy )- BORDER2),
	                           0, m_vValues.GetCount()-1);

}

void SlideSw::GotFocus()
{
	Refresh();
}

void SlideSw::LostFocus()
{
	Refresh();
}

SlideSw::~SlideSw() {}
