#include "Image.h"

NAMESPACE_UPP

int ImageBuffer16::ScanKind() const{
	bool a255 = false;
	bool a0 = false;
	const RGBA16 *s = pixels;
	const RGBA16 *e = s + GetLength();
	while(s < e) {
		if(s->a == 0)
			a0 = true;
		else
		if(s->a == 255)
			a255 = true;
		else
			return IMAGE_ALPHA;
		s++;
	}
	return a255 ? a0 ? IMAGE_MASK : IMAGE_OPAQUE : IMAGE_EMPTY;
}

void ImageBuffer16::SetHotSpots(const Image& src){
	SetHotSpot(src.GetHotSpot());
	Set2ndSpot(src.Get2ndSpot());
}

void ImageBuffer16::Create(int cx, int cy){
	ASSERT(cx >= 0 && cy >= 0);
	size.cx = cx;
	size.cy = cy;
	pixels.Alloc(GetLength());
#ifdef _DEBUG
	RGBA16 *s = pixels;
	RGBA16 *e = pixels + GetLength();
	byte  a = 0;
	while(s < e) {
		s->a = a;
		a = ~a;
		s->r = 255;
		s->g = s->b = 0;
		s++;
	}
#endif
	kind = IMAGE_UNKNOWN;
	spot2 = hotspot = Point(0, 0);
	dots = Size(0, 0);
}

void ImageBuffer16::DeepCopy(const ImageBuffer16& img){
	Create(img.GetSize());
	SetHotSpot(img.GetHotSpot());
	Set2ndSpot(img.Get2ndSpot());
	SetDots(img.GetDots());
	memcpy(pixels, img.pixels, GetLength() * sizeof(RGBA16));
}

void ImageBuffer16::Set(Image& img){
	if(img.data){
		Clear();
		Create(img.GetSize());
		const RGBA *s = img;
		const RGBA *e = s+img.GetLength();
		RGBA16 *t = pixels;
		uint32 max_range = uint32(pow(2.0f, 16))-1;
		
		while(s<e){
			t->r = s->r * max_range / 255;
			t->g = s->g * max_range / 255;
			t->b = s->b * max_range / 255;
			t->a = s->a * max_range / 255;
			++s;
			++t;
		}
	}else
		Create(0, 0);
}

void ImageBuffer16::Set(ImageBuffer16& img){
	//TODO
}

void ImageBuffer16::operator=(Image& img){
	Clear();
	Set(img);
}

void ImageBuffer16::operator=(ImageBuffer16& img){
	Clear();
	Set(img);
}

ImageBuffer16::ImageBuffer16(Image& img){
	Set(img);
}

ImageBuffer16::ImageBuffer16(ImageBuffer16& b){
	kind = b.kind;
	size = b.size;
	dots = b.dots;
	pixels = b.pixels;
	hotspot = b.hotspot;
	spot2 = b.spot2;
}

void ImageBuffer16::SetDPI(Size dpi) {
	dots.cx = int(600.*size.cx/dpi.cx);
	dots.cy = int(600.*size.cy/dpi.cy);
}

Size ImageBuffer16::GetDPI() {
	return Size(dots.cx ? int(600.*size.cx/dots.cx) : 0, dots.cy ? int(600.*size.cy/dots.cy) : 0);
}

END_UPP_NAMESPACE