#ifndef _ImageView_Image_h_
#define _ImageView_Image_h_

#include <Draw/Draw.h>
#include "Color.h"

NAMESPACE_UPP

class ImageBuffer16 : NoCopy {
	mutable int  kind;
	Size         size;
	Buffer<RGBA16> pixels;
	Point        hotspot;
	Point        spot2;
	Size         dots;

	void         Set(Image& img);
	void         Set(ImageBuffer16& img);
	void         DeepCopy(const ImageBuffer16& img);

	RGBA16*        Line(int i) const      { ASSERT(i >= 0 && i < size.cy); return (RGBA16 *)~pixels + i * size.cx; }
	friend void  DropPixels___(ImageBuffer16& b) { b.pixels.Clear(); }

	friend class Image;

public:
	void  SetKind(int k)                { kind = k; }
	int   GetKind() const               { return kind; }
	int   ScanKind() const;
	int   GetScanKind() const           { return kind == IMAGE_UNKNOWN ? ScanKind() : kind; }

	void  SetHotSpot(Point p)           { hotspot = p; }
	Point GetHotSpot() const            { return hotspot; }

	void  Set2ndSpot(Point p)           { spot2 = p; }
	Point Get2ndSpot() const            { return spot2; }
	
	void  SetHotSpots(const Image& src);

	void  SetDots(Size sz)              { dots = sz; }
	Size  GetDots() const               { return dots; }
	void  SetDPI(Size sz);
	Size  GetDPI();

	Size  GetSize() const               { return size; }
	int   GetWidth() const              { return size.cx; }
	int   GetHeight() const             { return size.cy; }
	int   GetLength() const             { return size.cx * size.cy; }

	RGBA16 *operator[](int i)             { return Line(i); }
	const RGBA16 *operator[](int i) const { return Line(i); }
	RGBA16 *operator~()                   { return pixels; }
	operator RGBA16*()                    { return pixels; }
	const RGBA16 *operator~() const       { return pixels; }
	operator const RGBA16*() const        { return pixels; }

	void  Create(int cx, int cy);
	void  Create(Size sz)               { Create(sz.cx, sz.cy); }
	bool  IsEmpty() const               { return (size.cx | size.cy) == 0; }
	void  Clear()                       { Create(0, 0); }

	void  operator=(Image& img);
	void  operator=(ImageBuffer16& img);

	ImageBuffer16()                       { Create(0, 0); }
	ImageBuffer16(int cx, int cy)         { Create(cx, cy); }
	ImageBuffer16(Size sz)                { Create(sz.cx, sz.cy); }
	ImageBuffer16(Image& img);
	ImageBuffer16(ImageBuffer16& b);
};

struct TIFFPage {
	uint32       width, height;
	uint16       bits_per_sample;
	uint16       samples_per_pixel;
	uint16       photometric;
	Size         dot_size;
	bool         alpha;
};

Image LoadImageAutolevel(const char *filename);
Image LoadImageAutolevel(const char *filename, const String tiff_ext);

Image ImageAutolevel(const ImageBuffer& img);

Image ImageAutolevel(const ImageBuffer16& img);

template<class ImageBUffT, class T, int Bits>
Image ImageAutolevelDet(const ImageBUffT &img);

template<class ImageBUffT, class T, int Bits>
Image ImageEequalizeDet(const ImageBUffT &img);

END_UPP_NAMESPACE

#endif
