#ifndef _ImageView_Color_h_
#define _ImageView_Color_h_

#include <Draw/Draw.h>

NAMESPACE_UPP

struct RGBA16 : Moveable<RGBA16>{
	uint16 r, g, b, a;
};

struct CIELAB : Moveable <CIELAB>{
	double l, a, b;
};

inline bool operator==(const RGBA16& a, const RGBA16& b){
	return a.r == b.r && a.g == b.g && a.b == b.b && a.a == b.a;
};

inline bool operator!=(const RGBA16& a, const RGBA16& b){
	return !(a == b);
};

inline RGBA16 RGBA16Zero() { RGBA16 c; c.r = c.g = c.b = c.a = 0; return c; };

void Fill(RGBA16 *t, const RGBA16& src, int n);
void FillColor(RGBA16 *t, const RGBA16& src, int n);

void Copy(RGBA16 *t, const RGBA16 *s, int n);

int  Premultiply(RGBA16 *t, const RGBA16 *s, int len);
int  Unmultiply(RGBA16 *t, const RGBA16 *s, int len);

void RGBtoXYZ(double r, double g, double b, double& x, double& y, double& z);
void XYZtoRGB(double x, double y, double z, int &r, int &g, int &b);
void XYZtoCEILab(double x, double y, double z, double& l, double& a, double& b);
void CEILabtoXYZ(double l, double a, double b, double& x, double& y, double& z);
void RGBtoCEILab(double r, double g, double b, double& l, double& a, double& lb);
void CEILabtoRGB(double l, double a, double lb, double& r, double& g, double& b);

END_UPP_NAMESPACE

#endif
