# Partial conversion of U++ package file to CMakeLists.txt
# Attention: Overwrites existing CMakeLists.txt file inside U++ package directory
# Usage:
# To create library:
# cmake -DUPP_FILE=PackageName.upp -P UppToCMakeLists.cmake
# To create executable:
# cmake -DUPP_FILE=PackageName.upp -DAPP_TYPE=1 -P UppToCMakeLists.cmake

cmake_minimum_required(VERSION 2.8)

if(NOT UPP_FILE)
	message(FATAL_ERROR "Specify UPP_FILE directive to path for U++ package")
endif(NOT UPP_FILE)

if(NOT EXISTS ${UPP_FILE})
	message(FATAL_ERROR "Specified file doesn't exists: ${UPP_FILE}")
endif(NOT EXISTS ${UPP_FILE})

get_filename_component(PKG_NAME ${UPP_FILE} NAME_WE)
get_filename_component(PKG_PATH ${UPP_FILE} PATH)

file(READ ${UPP_FILE} UPP_PKG)

string(REGEX MATCHALL "[file](\n.*)*" FILE_LIST ${UPP_PKG})
#string(REGEX MATCH "[^file\n].*" FILE_LIST ${FILE_LIST}) # to exclude file string from search
string(REGEX MATCHALL "[a-zA-Z0-9 ]*[.]+c([p]+)?" SRC_LIST ${FILE_LIST})
string(REGEX MATCHALL "[a-zA-Z0-9 ]*[.]+icpp" INIT_LIST ${FILE_LIST})

if(NOT SRC_LIST)
    message(FATAL_ERROR "There are no (*.c, *.cpp) files inside U++ package")
endif(NOT SRC_LIST)

set(contents "set(SRC_LIST\n")

foreach(var ${SRC_LIST})
    set(contents "${contents}\t${var}\n")
endforeach(var)

set(contents "${contents})\n")

if(INIT_LIST)
    set(contents "${contents}\nset(INIT_LIST\n")

    foreach(var ${INIT_LIST})
        set(contents "${contents}\t${var}\n")
    endforeach(var)

    set(contents "${contents})\n")
endif(INIT_LIST)

if(APP_TYPE EQUAL 1)
    set(contents "${contents}\nadd_executable(${PKG_NAME} \${SRC_LIST})\n")
else(APP_TYPE EQUAL 1)
    set(contents "${contents}\nadd_library(${PKG_NAME} \${SRC_LIST})\n")
endif(APP_TYPE EQUAL 1)

set(contents "${contents}\nset(USES_LIST) # dependent packages to link")
set(contents "${contents}\nset(LINK_LIST) # libraries to link\n")

set(contents
"${contents}\nif(DEFINED USES_LIST)\n"
"\tadd_dependencies(${PKG_NAME} \${USES_LIST})\n"
"endif(DEFINED USES_LIST)\n"
)

set(contents
"${contents}\nif(DEFINED USES_LIST OR DEFINED LINK_LIST)\n"
"\ttarget_link_libraries(${PKG_NAME} \${USES_LIST} \${LINK_LIST})\n"
"endif(DEFINED USES_LIST)\n"
)

set(CMAKE_PKG_PATH "${PKG_PATH}/CMakeLists.txt")
file(WRITE ${CMAKE_PKG_PATH} ${contents})

message("The '${CMAKE_PKG_PATH}' file written successfully")
