#include "V8JS.h"
#include "macros.h"

#include <Core/Core.h>

NAMESPACE_UPP
#define LLOG(x) LOG(x)
/*
V8JS_App::V8JS_App(){
}

V8JS_App::~V8JS_App(){
}

bool V8JS_App::Execute(String script_text, String relative_root){
	v8::Locker locker;
	v8::HandleScope handle_scope;

	int result = true;
	this->CreateContext();
	this->mainModule = v8::Object::New();

	try {
		v8::TryCatch tc;

		this->Prepare();
		if (tc.HasCaught()) { throw this->FormatException(&tc); } // uncaught exception when autoloading
		
		if (this->mainfile == "") { throw String("Nothing to do :)"); }
		this->require(this->mainfile, path_getcwd()); 
		if (tc.HasCaught()) { throw this->FormatException(&tc); } // uncaught exception when executing main file

	} catch (String e) {

		result = false;

		v8::Handle<v8::Value> show = this->get_config("showErrors");
		if (show->ToBoolean()->IsTrue()) {
			this->js_error(e.c_str()); 
		} else {
			this->error(e.c_str(), __FILE__, __LINE__);
		}
	}
	
	this->finish();
	return result;
}

 // Initialize and setup the context. Executed during every request, prior to executing main request file.
bool V8JS_App::Prepare(String &error) {
	v8::HandleScope handle_scope;
	v8::Handle<v8::Object> g = JS_GLOBAL;

	std::string root = GetCurrentDirectory();
	g->Set(JS_STR("require"), v8::FunctionTemplate::New(_require, JS_STR(root.c_str()))->GetFunction());
	g->Set(JS_STR("onexit"), v8::FunctionTemplate::New(_onexit)->GetFunction());
	g->Set(JS_STR("exit"), v8::FunctionTemplate::New(_exit)->GetFunction());
	g->Set(JS_STR("global"), g);

	this->paths = v8::Persistent<v8::Array>::New(v8::Array::New());

	// config file
	this->include(path_normalize(this->cfgfile), path_getcwd());

	if (!this->paths->Length()) { 
		error << "require.paths is empty, have you forgotten to push some data there?";
		return false;
	}

	setup_v8cgi(g);
	setup_system(g, envp, this->mainfile, this->mainfile_args);
	
	// default libraries
	return this->Autoload(error);
}


 // Require a module.
 // @param {std::string} name
 // @param {std::string} relativeRoot module root for relative includes
v8::Handle<v8::Object> V8JS_App::Require(String name, String relativeRoot) {
	v8::HandleScope hs;
	LLOG(Format("[require] looking for '%s'\n", name)); 
	modulefiles files = this->resolve_module(name, relativeRoot);
	
	if (!files.size()) { 
		std::string error = "Cannot find module '";
		error += name;
		error += "'";
		throw error;
	}

#ifdef VERBOSE
	printf("[require] resolved as '%s' (%d files)\n", files[0].c_str(), files.size()); 
#endif	

	// module name is the first component => hybrid modules are indexed by their native part
	std::string modulename = files[0];
	modulename = modulename.substr(0,  modulename.find_last_of('.'));
	
	v8::Handle<v8::Object> exports = this->cache.getExports(modulename);
	// check if exports are cached
	if (!exports.IsEmpty()) { return exports; }
	
	// create module-specific require + include
	v8::Handle<v8::Function> require = this->build_require(modulename, _require);
	v8::Handle<v8::Function> include = this->build_require(modulename, _include);

	// add new blank exports to cache
	exports = v8::Object::New();
	this->cache.addExports(modulename, exports);

	// create/use the "module" variable"
	v8::Handle<v8::Object> module = (name == this->mainfile ? this->mainModule : v8::Object::New());
	module->Set(JS_STR("id"), JS_STR(modulename.c_str()));

	int status = 0;
	for (unsigned int i=0; i<files.size(); i++) {
		std::string file = files[i];
		std::string ext = file.substr(file.find_last_of('.')+1, std::string::npos);
		if (ext == STRING(DSO_EXT)) {
			this->load_dso(file, require, include, exports, module);
		} else {
			status = this->load_js(file, require, include, exports, module);
			if (status != 0) {
				this->cache.removeExports(modulename);
				return hs.Close(exports);
			}
		}
		
	}

	return hs.Close(exports);
}

 // Convert JS exception to c string 
String V8JS_App::FormatException(v8::TryCatch* try_catch) {
	v8::HandleScope handle_scope;
	v8::String::Utf8Value exception(try_catch->Exception());
	v8::Handle<v8::Message> message = try_catch->Message();
	String msgstring = "";

	if (message.IsEmpty()) {
		msgstring << *exception;
	} else {
		v8::String::Utf8Value filename(message->GetScriptResourceName());
		int linenum = message->GetLineNumber();
		msgstring << *exception;
		msgstring << " (";
		msgstring << *filename;
		msgstring << ":";
		msgstring << linenum;
		msgstring << ")";
		
		v8::Handle<v8::Value> stack = try_catch->StackTrace();
		if (!stack.IsEmpty()) {
			v8::String::Utf8Value sstack(stack);
			msgstring << "\n";
			msgstring << *sstack;
		}
	}
	return msgstring;
}
*/
END_UPP_NAMESPACE
