#include "V8JS.h"
#include "macros.h"

//#include <Core/Core.h>

NAMESPACE_UPP
#define LLOG(x) LOG(x)

V8JS::V8JS(){
}

void V8JS::CreateContext(){
	v8::HandleScope handle_scope;
	
	if (this->global.IsEmpty()) {
		this->globalt = v8::Persistent<v8::ObjectTemplate>::New(v8::ObjectTemplate::New());
		this->globalt->SetInternalFieldCount(1); // pointer to this class
		this->context = v8::Context::New(NULL, this->globalt);
		this->context->Enter();
		this->global = v8::Persistent<v8::Value>::New(JS_GLOBAL);
		JS_GLOBAL_PROTO->SetInternalField(0, v8::External::New((void *) this));
		//GLOBAL_PROTO->SetInternalField(1, v8::External::New((void *) &(this->gc)));
	} else {
		this->context = v8::Context::New(NULL, this->globalt, this->global);
		this->context->Enter();
		JS_GLOBAL_PROTO->SetInternalField(0, v8::External::New((void *) this));
		//GLOBAL_PROTO->SetInternalField(1, v8::External::New((void *) &(this->gc)));
	}
}

void V8JS::DeleteContext() {
	this->context->DetachGlobal();
	this->context->Exit();
	this->context.Dispose();
	this->context.Clear();
}

V8JS::HandleScript V8JS::CompileIndependent(const String &s, const String &k){
	return v8::Script::New(JS_STR(~s), JS_STR(~k));
}

V8JS::HandleScript V8JS::Compile(const String &s){
	return v8::Script::Compile(JS_STR(~s));
}

V8JS::HandleValue V8JS::Execute(const String &s){
	v8::Locker locker;
	v8::HandleScope handle_scope;
	
	CreateContext();
	
	HandleObject g = JS_GLOBAL;
	ClearError();
	
	Prepare(g);
	
	//HandleScript curr_script = Compile(s);
	v8::TryCatch tc;
	HandleValue curr_result = Compile(s)->Run();
	if (tc.HasCaught()) {SetJsError(&tc); }
	Finish();
	
	DeleteContext();
	return curr_result;
}

void V8JS::SetJsError(v8::TryCatch* try_catch) {
	v8::HandleScope handle_scope;
	v8::String::Utf8Value exception(try_catch->Exception());
	v8::Handle<v8::Message> message = try_catch->Message();
	ClearError();


	if (message.IsEmpty()) {
		last_error << *exception;
	} else {
		v8::String::Utf8Value filename(message->GetScriptResourceName());
		int linenum = message->GetLineNumber();
		last_error << *exception;
		last_error << " (";
		last_error << *filename;
		last_error << ":";
		last_error << linenum;
		last_error << ")";
		
		v8::Handle<v8::Value> stack = try_catch->StackTrace();
		if (!stack.IsEmpty()) {
			v8::String::Utf8Value sstack(stack);
			last_error << "\n";
			last_error << *sstack;
		}
	}
}

END_UPP_NAMESPACE
