#ifndef _V8JS_V8JS_h_
#define _V8JS_V8JS_h_

#include <Core/Core.h>

#define USING_V8_SHARED 1

#include "lib/v8.h"

NAMESPACE_UPP

class V8JS{
public:
	V8JS();
	template<class T>
	//typedef v8::Handle<T> Handle<T>;
	class Handle : public v8::Handle<T>{};
	typedef v8::Object Object;
	typedef v8::Handle<v8::Script> HandleScript;
	typedef v8::Handle<v8::Value> HandleValue;
	typedef Array<v8::Persistent<v8::Function> > V8Functions;
	typedef v8::Locker Locker;
	typedef v8::ScriptData ScriptData;
	typedef v8::Persistent<v8::Context> PersistentContext;
	typedef v8::Persistent<v8::Value> PersistentValue;
	typedef v8::Persistent<v8::ObjectTemplate> PersistentObjectTemplate;
	typedef v8::Handle<v8::Object> HandleObject;
	typedef v8::FunctionTemplate FunctionTemplate;
	typedef v8::Arguments Arguments;
	typedef HandleValue (*InvocationCallback)(const Arguments& args);

	void CreateContext();
	void DeleteContext();
	
	HandleScript CompileIndependent(const String &s, const String &k);
	HandleScript Compile(const String &s);
	
	HandleValue Execute(const String &s);
	
	static String ConvertValueIntoString(HandleValue &obj){
		v8::String::Utf8Value curr_str(obj);
		return String(*curr_str);
	}
	virtual size_t system_read(char * destination, size_t amount){
		return fread((void *) destination, sizeof(char), amount, stdin);
	};
	virtual size_t system_write(const char * data, size_t amount){
		//Cout() << data;
		//return 0;
		return fwrite((void *) data, sizeof(char), amount, stdout);
	};
	V8Functions OnExitFunctions;
	Callback1<HandleObject> OnPrepare;
	bool IsError()		{return !IsEmpty(last_error);};
	void ClearError()	{last_error = "";};
	String GetLastError() {return last_error;};
protected:
	virtual void Prepare(HandleObject target);
	virtual void Finish();
	PersistentContext context;
	PersistentValue global;
	PersistentObjectTemplate globalt;
	String last_error;
	void SetJsError(v8::TryCatch* try_catch);
private:
};

//#include "V8JS_APP.h"

END_UPP_NAMESPACE

#endif
