#include "macros.h"
#include "V8JS.h"

NAMESPACE_UPP
/*
 // global.require = load module and return its (cached) exports
JS_METHOD(_require) {
	v8::String::Utf8Value file(args[0]);
	String root = *(v8::String::Utf8Value(args.Data()));
	
	try {
		return V8JS_PTR->Require(*file, root);
	} catch (String e) {
		return JS_ERROR(~e);
	}
}
*/
JS_METHOD(_onexit) {
	if (!args[0]->IsFunction()) { return JS_TYPE_ERROR("Non-function passed to onexit()"); }
	v8::Persistent<v8::Function> fun = v8::Persistent<v8::Function>::New(v8::Handle<v8::Function>::Cast(args[0]));
	V8JS_PTR->OnExitFunctions.Add(fun);
	return v8::Undefined();
}

/**
 * global.exit - terminate execution
 */
JS_METHOD(_exit) {
	v8::V8::TerminateExecution();
	/* do something at least a bit complex so the stack guard can throw the termination exception */
	v8::Script::Compile(JS_STR("(function(){})()"))->Run();
	return v8::Undefined();
}
/*
JS_METHOD(_system_read) {
	V8JS * app = V8JS_PTR;
	size_t count = 0;
	
	if (args.Length() && args[0]->IsNumber()) {
		count = args[0]->IntegerValue();
	}
	
	std::string data;
	size_t size = 0;

	if (count == 0) { // all
		size_t tmp;
		char * buf = new char[1024];
		do {
			tmp = app->system_read(buf, sizeof(buf));
			size += tmp;
			data.insert(data.length(), buf, tmp);
		} while (tmp == sizeof(buf));
		delete[] buf;
	} else {
		char * tmp = new char[count];
		size = app->system_read(tmp, count);
		data.insert(0, tmp, size);
		delete[] tmp;
	}
	
	return JS_BUFFER((char *) data.data(), size);
}
*/

JS_METHOD(_system_write) {
	V8JS * app = V8JS_PTR;
	if (!((v8::Handle<v8::Value>)(args[0]))->IsObject()) {
		v8::String::Utf8Value str(args[0]);
		app->system_write(*str, str.length());
	}
	return v8::Undefined();
}

JS_METHOD(_v8_version) {
	V8JS * app = V8JS_PTR;
	return JS_STR(v8::V8::GetVersion());
}


void V8JS::Prepare(HandleObject target){
	target->Set(JS_STR("onexit"), FunctionTemplate::New(_onexit)->GetFunction());
	target->Set(JS_STR("exit"), FunctionTemplate::New(_exit)->GetFunction());
	target->Set(JS_STR("global"), target);
	//target->Set(JS_STR("V8Version"), FunctionTemplate::New(_v8_version)->GetFunction());
	
	// system constructor
	
	HandleObject system = v8::Object::New();
	target->Set(JS_STR("system"), system);
	
	//system->Set(JS_STR("read"), FunctionTemplate::New(_read)->GetFunction())
	system->Set(JS_STR("write"), FunctionTemplate::New(_system_write)->GetFunction());
	
	HandleObject v8_object = v8::Object::New();
	target->Set(JS_STR("v8"), v8_object);
	
	v8_object->Set(JS_STR("Version"), FunctionTemplate::New(_v8_version)->GetFunction());
	
	OnPrepare(target);
}

void V8JS::Finish(){
	for (int i=0; i<this->OnExitFunctions.GetCount(); ++i) {
		this->OnExitFunctions[i]->Call(JS_GLOBAL, 0, NULL);
		this->OnExitFunctions[i].Dispose();
		this->OnExitFunctions[i].Clear();
	}
	this->OnExitFunctions.Clear();
}

END_UPP_NAMESPACE
