#include <CtrlLib/CtrlLib.h>
#include <V8JS/V8JS.h>
#include <V8JS/macros.h>

using namespace Upp;

JS_METHOD(_v8_alert){
	V8JS * app = V8JS_PTR;
	if (!((v8::Handle<v8::Value>)(args[0]))->IsObject()) {
		v8::String::Utf8Value str(args[0]);
		PromptOK(DeQtfLf(*str));
	}
	return v8::Undefined();
}

void PrepareV8JSCustom(V8JS::HandleObject target){
	target->Set(JS_STR("alert"), v8::FunctionTemplate::New(_v8_alert)->GetFunction());
}

#define LAYOUTFILE <V8JS_Test/forms.lay>
#include <CtrlCore/lay.h>

class V8JSForm : public WithJSExecution<TopWindow>{
public:
	typedef V8JSForm CLASSNAME;
	V8JSForm(){
		CtrlLayout(*this);
		Title("V8 JavaScript code sample");
		Sizeable();
		Zoomable();
		MinimizeBox();
		MaximizeBox();
		curr_V8JS.OnPrepare = callback(PrepareV8JSCustom);
		execute_button.WhenAction << THISBACK(ExecuteCode);
		String s_code("a = function(){"
				"\n onexit(function(){alert('Bye from a!');});"
				"\n	alert('test a');"
				"\n	this.b = function(){"
				"\n		alert('test b from a');"
				"\n 	onexit(function(){alert('Bye b from a!');});"
				"\n	}"
				"\n	this.c = 3;"
				"\n}"
				"\nc = new a();"
				"\nc.b();"
				"\nalert(c.c);"
				"\na.prototype.d = 4;"
				"\nalert(c.d);"
				"\nalert('v8 version is '+v8.Version());"
		);
		CodeForExecution.SetData(s_code);
	}
protected:
	void ExecuteCode(){
		V8JS::Locker locker;
		V8JS::HandleValue result = curr_V8JS.Execute(CodeForExecution.GetData());
		if(curr_V8JS.IsError()){
			PromptOK(DeQtf(Format("JavaScriptError: %s", curr_V8JS.GetLastError())));
		}
		//PromptOK(DeQtf(Format("Result: %s", V8JS::ConvertValueIntoString(result))));
	}
private:
	V8JS curr_V8JS;
};

// U++ example

GUI_APP_MAIN{
	V8JSForm main_form;
	main_form.Run();
}

// v8 original example
/*
int main(int argc, char* argv[]) {
	// Create a stack-allocated handle scope.
	v8::HandleScope handle_scope;
	
	// Create a new context.
	v8::Persistent<v8::Context> context = v8::Context::New();
	
	// Enter the created context for compiling and
	// running the hello world script. 
	v8::Context::Scope context_scope(context);
	
	// Create a string containing the JavaScript source code.
	v8::Handle<v8::String> source = v8::String::New("'Hello' + ', World from U++!'");
	
	// Compile the source code.
	v8::Handle<v8::Script> script = v8::Script::Compile(source);
	
	// Run the script to get the result.
	v8::Handle<v8::Value> result = script->Run();
	v8::String::AsciiValue ascii(result);
	printf("%s\n", *ascii);
	return 0;
}
*/