#include "ExcelDataToWordLayoutTemplate.h"

#define TOPICFILE <ExcelDataToWordLayoutTemplate/app.tpp/all.i>
#include <Core/topic_group.h>

#define IMAGECLASS ExcelImgs
#define IMAGEFILE <ExcelDataToWordLayoutTemplate/Images.iml>
#include <Draw/iml_source.h>

ExcelDataToWordLayoutTemplate::ExcelDataToWordLayoutTemplate() {
	AtomicWrite(converting, 0);
	CtrlLayout(*this, "Excel data to Word layout template");
	Sizeable();
	MinimizeBox();
	MaximizeBox();
	SetMinSize(Size(10,10));
	//Icon(OracleXmlToXslImg::Logo());
	Title("Convert MS Excel data file to MS Word layout template");
	StartButton <<= THISBACK(OnBtnConvert);
	HelpButton <<=THISBACK(OnHelp);
	ExcelDataFile.Type("MS Excel 97-2003", "*.xls");
	ExcelDataFile.Type("MS Excel 2007", "*.xlsx");
	ExcelDataFile.Type("All files", "*.*");
	WordLayoutTemplate.Type("MS Word 97-2003", "*.doc");
	WordLayoutTemplate.Type("MS Word 2007", "*.docx");
	WordLayoutTemplate.Type("All files", "*.*");
	ExcelHeaderRow.SetData(1);
	AddFrame(main_bar);
	Icon(ExcelImgs::icon());
}

void ExcelDataToWordLayoutTemplate::OnBtnConvert(){
	if((!stop_process)&&(AtomicRead(converting))){
		//CtrlLogText.Insert(CtrlLogText.GetLength(), String(" - Canceled by user!").Cat() << "\n");
		stop_process = true;
		//BtnConvertXmlToXsl.Image(OracleXmlToXslImg::Open());
		//AtomicWrite(converting, 0);
		StartButton.SetLabel(t_("Convert"));
		return;
	}
	StartButton.SetLabel(t_("Stop convert"));
	
	AtomicWrite(converting, 1);
	stop_process = false;
	//SetTimeCallback(-200, THISBACK(UpdateProgress), TIMEID_PROGRESS);
	Thread().Run(THISBACK1(Convert, THISBACK(CheckCancel)));
	
	while(AtomicRead(converting)) {
		ProcessEvents();
		GuiSleep(300);
	}
	
	StartButton.SetLabel(t_("Convert"));
	//KillTimeCallback(TIMEID_PROGRESS);
	
	//BtnConvertXmlToXsl.Image(OracleXmlToXslImg::Open());
}

void ExcelDataToWordLayoutTemplate::Convert(Gate3<int64, int64, String>& p_progress){
	String v_error;
	
	bool visible_mode = ~InVisibleMode;
	OfficeSheet sheet;
	

	bool openAvailable = sheet.IsAvailable("Open");
	bool microsoftAvailable = sheet.IsAvailable("Microsoft");
	
	if (microsoftAvailable) {
		sheet.Init("Microsoft");
	}else if (openAvailable) {
		sheet.Init("Open");
	}else{
		Exclamation(DeQtf(t_("MS MS Excel or Open Office is not installed! Install one of this and rerun the application!")));
		return;
	}
	
	OfficeDoc doc;
	
	openAvailable = doc.IsAvailable("Open");
	microsoftAvailable = doc.IsAvailable("Microsoft");
	
	if (microsoftAvailable) {
		doc.Init("Microsoft");
	}else if (openAvailable) {
		doc.Init("Open");
	}else{
		Exclamation(DeQtf(t_("MS MS Word or Open Office is not installed! Install one of this and rerun the application!")));
		return;
	}
	
	if (!sheet.OpenSheet(~ExcelDataFile, visible_mode)) {
		Exclamation(DeQtf(t_("Excel file does nod exists!")));
		return;
	}
	if (!doc.OpenDoc(~WordLayoutTemplate, visible_mode)) {
		Exclamation(DeQtf(t_("Word file does nod exists!")));
		return;
	}
	
	if(!sheet.ChooseTab(0)){
		Exclamation(DeQtf(t_("Worksheets does not exist!")));
		return;
	}
	
	int header_row = ~ExcelHeaderRow;
	
	if((header_row<1)||(header_row>50000)){
		Exclamation(DeQtf(t_("Invalid row header number!")));
		return;
	}
	
	ArrayMap<int, String> remplae_names;
	
	int i = 1;
	int tries = 0;
	String message_str;
	message_str = "Get header..";
	p_progress(0, 0, message_str);
	Array<String> replase_strings;
	while(tries<3){
		Value &curr_v = sheet.GetValue(i, header_row);
		String curr_name = curr_v;
		if(!curr_name.IsEmpty()){
			tries = 0;
			remplae_names.Add(i, curr_name);
			replase_strings.Add();
		}else ++tries;
		++i;
	}
	
	tries = 0;
	String replace_str;
	String to_replace;
	String new_file;
	bool all_nuls = true;
	while(tries<3){
		++header_row;
		message_str <<= Format("uploading row %d", header_row);
		if(p_progress(0, 0, message_str)){
			break;
		}
		
		new_file = GetFileTitle(String(~WordLayoutTemplate));
		new_file << "_row_" << header_row << ".doc";
		new_file = AppendFileName(~OutputDirectory, new_file);
		if (!doc.OpenDoc(~WordLayoutTemplate, visible_mode)) {
			Exclamation(DeQtf(t_("Word file does nod exists!")));
			return;
		}
		
		all_nuls = true;
		
		for(i=0;i<remplae_names.GetCount();++i){
			replace_str = sheet.GetText(remplae_names.GetKey(i), header_row);
			replase_strings.Set(i, replace_str);
			if(all_nuls&&!replace_str.IsEmpty()){
				all_nuls = false;
			}
		}
		if(!all_nuls){
			for(i=0;i<remplae_names.GetCount();++i){
				to_replace = "";
				to_replace << "[" << (remplae_names[i]) << "]";
				doc.Replace(to_replace, replase_strings[i]);
			}
			doc.SaveAs(new_file, "doc");
			tries = 0;
		}else ++tries;
	}
	
	doc.Quit();
	sheet.Quit();
	PromptOK(DeQtf(t_("All rows processed")));
	AtomicWrite(converting, 0);
}

void ExcelDataToWordLayoutTemplate::Serialize(Stream &data){
	data.Magic();
	String excelDataFile = ~ExcelDataFile;
	int excelHeaderRow = ~ExcelHeaderRow;
	String wordLayoutTemplate = ~WordLayoutTemplate;
	String outputDirectory = ~OutputDirectory;
	bool in_visible_mode = ~InVisibleMode;
	
	data%excelDataFile;
	data%excelHeaderRow;
	data%wordLayoutTemplate;
	data%outputDirectory;
	data%in_visible_mode;
	
	if(data.IsLoading()){
		ExcelDataFile.SetData(excelDataFile);
		ExcelHeaderRow.SetData(excelHeaderRow);
		WordLayoutTemplate.SetData(wordLayoutTemplate);
		OutputDirectory.SetData(outputDirectory);
		InVisibleMode.SetData(in_visible_mode);
	}
}

bool ExcelDataToWordLayoutTemplate::CheckCancel(int64 p_pos, int64 p_total, String p_message){
	main_bar = p_message;
	//PromptOK("Canceled by user!");
/*
	if(!p_message.IsEmpty()){
		int cur_curs = CtrlLogText.GetCursor();
		int cur_len = CtrlLogText.GetLength();
		CtrlLogText.Insert(cur_len, p_message << "\n");
		
		if(cur_curs >= cur_len-1)
			CtrlLogText.SetCursor(CtrlLogText.GetLength());
		//CtrlLogText.Refresh();
	}
*/
//	ProcessEvents();
	
	//if((stop_process))
	//	AtomicWrite(converting, 0);
	
	return stop_process;
}

void ExcelDataToWordLayoutTemplate::OnHelp(){
	WithAboutLayout<TopWindow> dlg;
	
	dlg.text = GetTopic("topic://ExcelDataToWordLayoutTemplate/app/About$en-us").text;
	
	CtrlLayoutOK(dlg, t_("Help"));
	dlg.Sizeable();
	
	if(dlg.Execute() != IDOK)
		return;
}

GUI_APP_MAIN
{
	ExcelDataToWordLayoutTemplate app;
	LoadFromFile(app);
	app.Run();
	StoreToFile(app);
}
