class EditDir : public EditString{
public:
	typedef EditDir CLASSNAME;
	EditDir(){
		AddFrame(btn);
		//btn.SetImage(CtrlImg::smallright()).NoWantFocus();
		btn.SetLabel(String("...").Cat()).NoWantFocus();
		btn <<= THISBACK(SelectDir);
		btn.Tip(t_("Select directory (F4)"));
		NullText(t_("Select directory (F4)"));
	}
	virtual bool  Key(dword key, int rep){
		switch(key) {
		case K_F4:
			SelectDir();
			return true;
		};
		return EditField::Key(key, rep);
	};

	EditString& operator=(const WString& data)       { SetData(data); return *this; }
	EditString& operator=(const String& data)        { SetData(data); return *this; }
private:
	FrameRight<Button> btn;
	void SelectDir(){
		FileSel fs;
		if(!GetData().IsNull())
			fs.ActiveDir(GetData());
		else
			fs.ActiveDir(GetFileFolder(GetExeFilePath()));
		if(fs.ExecuteSelectDir())
			SetData(fs.Get());
	}
};

class EditFileOpen : public EditString{
public:
	typedef EditFileOpen CLASSNAME;
	EditFileOpen(){
		AddFrame(btn);
		//btn.SetImage(CtrlImg::smallright()).NoWantFocus();
		btn.SetLabel(String("...").Cat()).NoWantFocus();
		btn <<= THISBACK(SelectFile);
		btn.Tip(t_("Select file (F4)"));
		NullText(t_("Select file (F4)"));
	}
	virtual bool  Key(dword key, int rep){
		switch(key) {
		case K_F4:
			SelectFile();
			return true;
		};
		return EditField::Key(key, rep);
	};

	EditString& operator=(const WString& data)       { SetData(data); return *this; }
	EditString& operator=(const String& data)        { SetData(data); return *this; }
	void Type(const char *desc, const char *name){
		file_ext_descs.Add(desc);
		file_ext_filters.Add(name);
	}
private:
	FrameRight<Button> btn;
	Array<String> file_ext_descs;
	Array<String> file_ext_filters;
	void SelectFile(){
		FileSel fs;
		if(!GetData().IsNull())
			fs.Set(GetData());
		else
			fs.ActiveDir(GetFileFolder(GetExeFilePath()));
		for(int i = 0; i<file_ext_descs.GetCount();++i)
			fs.Type(file_ext_descs[i], file_ext_filters[i]);
		if(fs.ExecuteOpen(t_("Select file")))
			SetData(fs.Get());
	}
};

