#ifndef _ExcelDataToWordLayoutTemplate_ExcelDataToWordLayoutTemplate_h_
#define _ExcelDataToWordLayoutTemplate_ExcelDataToWordLayoutTemplate_h_
#include <Core/Core.h>

using namespace Upp;

#include <CtrlLib/CtrlLib.h>
#include <Functions4U/Functions4U.h>
#include <OfficeAutomation/OfficeAutomation.h>
#include "EditDir.h"

#define LAYOUTFILE <ExcelDataToWordLayoutTemplate/Forms.lay>
#include <CtrlCore/lay.h>

#define IMAGECLASS ExcelImgs
#define IMAGEFILE <ExcelDataToWordLayoutTemplate/Images.iml>
#include <Draw/iml_header.h>

class ExcelDataToWordLayoutTemplate : public WithMainForm<TopWindow> {
public:
	typedef ExcelDataToWordLayoutTemplate CLASSNAME;
	ExcelDataToWordLayoutTemplate();
	void OnBtnConvert();
	void Convert(Gate3<int64, int64, String>& p_progress);
	bool CheckCancel(int64 p_pos, int64 p_total, String p_message);
	void OnHelp();
	void Serialize(Stream &data);
private:
	String source_file_address;
	volatile Atomic converting;
	String excel_vendor_str;
	String word_vendor_str;
	StatusBar main_bar;
protected:
	bool stop_process;
};

#endif
