#include <lemon/list_graph.h>
#include <lemon/lgf_writer.h>
#include <Core/Core.h>

namespace ln = lemon;
using namespace Upp;

CONSOLE_APP_MAIN {
	ln::ListDigraph g;
	ln::ListDigraph::Node u = g.addNode();
	ln::ListDigraph::Node v = g.addNode();
	ln::ListDigraph::Arc  a = g.addArc(u, v);
	ln::ListDigraph::NodeMap<String> label(g);

	char c = 'Z';
	for (ln::ListDigraph::NodeIt n(g); n != ln::INVALID; ++n)
	{
		label[n] = AsString(c--);
	}

	Cout() << "Arcs: " << ln::countArcs(g)
		<< "\nNodes: " << ln::countNodes(g)
		<< "\nLabels:"
		<< "\nu = " << label[u]
		<< "\nv = " << label[v];

// Comment out following define, if you haven't crash on Speed build mode for GCC Builder.
#if !(defined(flagGCC) && defined(flagFORCE_SPEED)) || defined(flagUSEMALLOC)
	std::stringstream os;
	ln::DigraphWriter<ln::ListDigraph> dw(g, os);
	dw.run();

	Cout() << "\n\nLGF:\n" << String(os.str());
#endif

	Cout() << '\n';
}
