// AddIn.cpp

#include "stdafx.h"
#include "comutil.h"
#include "AddIn.h"

  // This global interface is for timer implementation only
static IAsyncEvent *pAsyncEvent = NULL;

VOID CALLBACK MyTimerProc(
    HWND hwnd,    // handle of window for timer messages
    UINT uMsg,    // WM_TIMER message
    UINT idEvent, // timer identifier
    DWORD dwTime  // current system time
);

/////////////////////////////////////////////////////////////////////////////
// CAddIn

BOOL CAddIn::LoadProperties()
{  
    HRESULT hRes;
    CString csProperty; 
    VARIANT varEnabled;

      // Load flag switching component activity on or off
    csProperty = "Enabled:0";

    ::VariantInit(&varEnabled);
    V_VT(&varEnabled) = VT_I4;
    hRes = m_iProfile->Read(csProperty.AllocSysString(),&varEnabled,NULL);
    if (hRes != S_OK) return FALSE;
    m_boolEnabled = V_I4(&varEnabled)?TRUE:FALSE;

    return TRUE;
}

void CAddIn::SaveProperties()
{
    CString csProperty; 
    VARIANT varEnabled;

      // Save flag switching component activity on or off
    csProperty = "Enabled";

    ::VariantInit(&varEnabled);
    V_VT(&varEnabled) = VT_I4;
    V_I4(&varEnabled) = m_boolEnabled?1:0;
    m_iProfile->Write(csProperty.AllocSysString(),&varEnabled);
}

CString CAddIn::TermString(UINT uiResID,long nAlias)
{
    CString cs;
    cs.LoadString(uiResID);
    int iInd = cs.Find(',');
    if (iInd == -1)
        return cs;
    switch(nAlias)
    {
    case 0: // First language
        return cs.Left(iInd);
    case 1: // Second language
        return cs.Right(cs.GetLength()-iInd-1);
    default:
        return CString("");
    };
}

  /* 
     These two methods is convenient way to access function 
     parameters from SAFEARRAY vector of variants
  */
VARIANT CAddIn::GetNParam(SAFEARRAY *pArray,long lIndex)
{
    ASSERT(pArray);
    ASSERT(pArray->fFeatures | FADF_VARIANT);

    VARIANT vt;
    HRESULT hRes = ::SafeArrayGetElement(pArray,&lIndex,&vt);
    ASSERT(hRes == S_OK);

    return vt;
}

void CAddIn::PutNParam(SAFEARRAY *pArray,long lIndex,VARIANT vt)
{
    ASSERT(pArray);
    ASSERT(pArray->fFeatures | FADF_VARIANT);

    HRESULT hRes = ::SafeArrayPutElement(pArray,&lIndex,&vt);
    ASSERT(hRes == S_OK);
}

/////////////////////////////////////////////////////////////////////////////
// IInitDone

STDMETHODIMP CAddIn::Init(IDispatch *pConnection)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())
    
    m_iConnect = pConnection;
    
    m_iErrorLog = NULL;
    pConnection->QueryInterface(IID_IErrorLog,(void **)&m_iErrorLog);

    m_iAsyncEvent = NULL;
    pConnection->QueryInterface(IID_IAsyncEvent,(void **)&m_iAsyncEvent);
    
    m_iStatusLine = NULL;
    pConnection->QueryInterface(IID_IStatusLine,(void **)&m_iStatusLine);

    CString csProfileName = "Sample AddIn Profile Name";
    m_iProfile = NULL;
    pConnection->QueryInterface(IID_IPropertyProfile,(void **)&m_iProfile);
    if (m_iProfile) 
    {
        m_iProfile->RegisterProfileAs(csProfileName.AllocSysString());
        if (LoadProperties() == FALSE)
            return E_FAIL;
    }

    return S_OK;
}

STDMETHODIMP CAddIn::Done()
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    if (m_uiTimer != 0)
        ::KillTimer(NULL,m_uiTimer);

    SaveProperties();

    if (m_iStatusLine) m_iStatusLine->Release();
    if (m_iProfile) m_iProfile->Release();
    if (m_iAsyncEvent) m_iAsyncEvent->Release();
    if (m_iErrorLog) m_iErrorLog->Release();
    
    return S_OK;
}

STDMETHODIMP CAddIn::GetInfo(SAFEARRAY **pInfo)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    // Component should put supported component technology version 
    // in VARIANT at index 0     
    long lInd = 0;
    VARIANT varVersion;
    V_VT(&varVersion) = VT_I4;
    // This component supports 1.0 version
    V_I4(&varVersion) = 1000;
    SafeArrayPutElement(*pInfo,&lInd,&varVersion);
    
    return S_OK;
}

/////////////////////////////////////////////////////////////////////////////
// ILanguageExtender

STDMETHODIMP CAddIn::RegisterExtensionAs(BSTR *bstrExtensionName)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    // You may delete next lines and add your own implementation code here

    // Name of extension should be changed avoiding conflicts 
    CString csExtenderName = "AddInExtension";
    *bstrExtensionName = csExtenderName.AllocSysString();

    return NULL;
}

STDMETHODIMP CAddIn::GetNProps(long *plProps)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    // You may delete next lines and add your own implementation code here

    *plProps = LastProp;

    return S_OK;
}

STDMETHODIMP CAddIn::FindProp(BSTR bstrPropName,long *plPropNum)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    USES_CONVERSION;

    *plPropNum = -1;
    CString csPropName = OLE2T(bstrPropName);

    if (TermString(IDS_TERM_ENABLED,0) == csPropName) *plPropNum = 0;
    if (TermString(IDS_TERM_ENABLED,1) == csPropName) *plPropNum = 0;
    if (TermString(IDS_TERM_TIMERPRESENT,0) == csPropName) *plPropNum = 1;
    if (TermString(IDS_TERM_TIMERPRESENT,1) == csPropName) *plPropNum = 1;

    return (*plPropNum == -1) ? S_FALSE : S_OK;
}

STDMETHODIMP CAddIn::GetPropName(long lPropNum,long lPropAlias,BSTR *pbstrPropName)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    USES_CONVERSION;

    CString csPropName = ""; 
    switch(lPropNum)
    {
    case propIsEnabled:
        csPropName = TermString(IDS_TERM_ENABLED,lPropAlias);
        *pbstrPropName = csPropName.AllocSysString();
        break;
    case propIsTimerPresent:
        csPropName = TermString(IDS_TERM_TIMERPRESENT,lPropAlias);
        *pbstrPropName = csPropName.AllocSysString();
        break;
    default:
        *pbstrPropName = csPropName.AllocSysString();
        return S_FALSE;
    }

    return S_OK;
}

STDMETHODIMP CAddIn::GetPropVal(long lPropNum,VARIANT *pvarPropVal)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    ::VariantInit(pvarPropVal);
    switch(lPropNum)
    {
    case propIsEnabled:
        V_VT(pvarPropVal) = VT_I4;
        V_I4(pvarPropVal) = m_boolEnabled?1:0;
        break;
    case propIsTimerPresent:
        V_VT(pvarPropVal) = VT_I4;
        V_I4(pvarPropVal) = 1;
        break;
    default:
        return S_FALSE;
    }

    return S_OK;
}

STDMETHODIMP CAddIn::SetPropVal(long lPropNum,VARIANT *pvarPropVal)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    switch(lPropNum)
    { 
    case propIsEnabled:
        if (V_VT(pvarPropVal) != VT_I4)
            return S_FALSE;
        m_boolEnabled = V_I4(pvarPropVal)?1:0;
        break;
    case propIsTimerPresent:
    default:
        return S_FALSE;
    }

    return S_OK;
}

STDMETHODIMP CAddIn::IsPropReadable(long lPropNum,BOOL *pboolPropRead)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    switch(lPropNum)
    { 
    case propIsEnabled:
        *pboolPropRead = TRUE;
        break;
    case propIsTimerPresent:
        *pboolPropRead = TRUE;
        break;
    default:
        return S_FALSE;
    }

    return S_OK;
}

STDMETHODIMP CAddIn::IsPropWritable(long lPropNum,BOOL *pboolPropWrite)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    switch(lPropNum)
    { 
    case propIsEnabled:
        *pboolPropWrite = TRUE;
        break;
    case propIsTimerPresent:
        *pboolPropWrite = FALSE;
        break;
    default:
        return S_FALSE;
    }

    return S_OK;
}

STDMETHODIMP CAddIn::GetNMethods(long *plMethods)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    // You may delete next lines and add your own implementation code here

    *plMethods = LastMethod;

    return S_OK;
}

STDMETHODIMP CAddIn::FindMethod(BSTR bstrMethodName, long *plMethodNum)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    USES_CONVERSION;

    *plMethodNum = -1;
    CString csPropName = OLE2T(bstrMethodName);

    if (TermString(IDS_TERM_ENABLE,0) == csPropName) *plMethodNum = 0;
    if (TermString(IDS_TERM_ENABLE,1) == csPropName) *plMethodNum = 0;

    if (TermString(IDS_TERM_DISABLE,0) == csPropName) *plMethodNum = 1;
    if (TermString(IDS_TERM_DISABLE,1) == csPropName) *plMethodNum = 1;

    if (TermString(IDS_TERM_SHOWSTATUS,0) == csPropName) *plMethodNum = 2;
    if (TermString(IDS_TERM_SHOWSTATUS,1) == csPropName) *plMethodNum = 2;

    if (TermString(IDS_TERM_STARTTIMER,0) == csPropName) *plMethodNum = 3;
    if (TermString(IDS_TERM_STARTTIMER,1) == csPropName) *plMethodNum = 3;

    if (TermString(IDS_TERM_STOPTIMER,0) == csPropName) *plMethodNum = 4;
    if (TermString(IDS_TERM_STOPTIMER,1) == csPropName) *plMethodNum = 4;

    if (TermString(IDS_TERM_OPENFORM,0) == csPropName) *plMethodNum = 5;
    if (TermString(IDS_TERM_OPENFORM,1) == csPropName) *plMethodNum = 5;

	return (*plMethodNum == -1) ? S_FALSE : S_OK;
}

STDMETHODIMP CAddIn::GetMethodName(long lMethodNum,long lMethodAlias,BSTR *pbstrMethodName)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CString csMethodName = "";     
    switch(lMethodNum)
    { 
    case methEnable:
        csMethodName = TermString(IDS_TERM_ENABLE,lMethodAlias);
        break;
    case methDisable:
        csMethodName = TermString(IDS_TERM_DISABLE,lMethodAlias);
        break;
    case methShowInStatusLine:
        csMethodName = TermString(IDS_TERM_SHOWSTATUS,lMethodAlias);
        break;
    case methStartTimer:
        csMethodName = TermString(IDS_TERM_STARTTIMER,lMethodAlias);
        break;
    case methStopTimer:
        csMethodName = TermString(IDS_TERM_STOPTIMER,lMethodAlias);
        break;
    case methOpenForm:
        csMethodName = TermString(IDS_TERM_OPENFORM,lMethodAlias);
        break;
    default:
        *pbstrMethodName = csMethodName.AllocSysString();
        return S_FALSE;
    }
    
    *pbstrMethodName = csMethodName.AllocSysString();

    return S_OK;
}

STDMETHODIMP CAddIn::GetNParams(long lMethodNum,long *plParams)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    *plParams = 0;
    switch(lMethodNum)
    { 
    case methEnable:
        *plParams = 0;
        break;
    case methDisable:
        *plParams = 0;
        break;
    case methShowInStatusLine:
        *plParams = 1;
        break;
    case methStartTimer:
        *plParams = 0;
        break;
    case methStopTimer:
        *plParams = 0;
        break;
    case methOpenForm:
        *plParams = 0;
        break;
    default:
        return S_FALSE;
    }
    
    return S_OK;
}

STDMETHODIMP CAddIn::GetParamDefValue(long lMethodNum,long lParamNum,VARIANT *pvarParamDefValue)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    ::VariantInit(pvarParamDefValue);
    switch(lMethodNum)
    { 
    case methEnable:
    case methDisable:
    case methShowInStatusLine:
    case methStartTimer:
    case methStopTimer:
    case methOpenForm:
        /* There are no parameter values by default */
        break;
    default:
        return S_FALSE;
    }

    return S_OK;
}

STDMETHODIMP CAddIn::HasRetVal(long lMethodNum,BOOL *pboolRetValue)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

    switch(lMethodNum)
    { 
    case methEnable:
    case methDisable:
    case methShowInStatusLine:
    case methStartTimer:
    case methStopTimer:
    case methOpenForm:
        /* All methods are procedures */
        *pboolRetValue = FALSE;
        break;
    default:
        return S_FALSE;
    }

    return S_OK;
}

STDMETHODIMP CAddIn::CallAsProc(long lMethodNum, SAFEARRAY **paParams)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    USES_CONVERSION;

    switch(lMethodNum)
    { 
    case methEnable:
        m_boolEnabled = TRUE;
        break;
    case methDisable:
        m_boolEnabled = FALSE;
        break;
    case methShowInStatusLine:
        if (m_iStatusLine)
        {
            VARIANT var = GetNParam(*paParams,0);
            m_iStatusLine->SetStatusLine(V_BSTR(&var));
            Sleep(5000);
            ::VariantClear(&var);
        }
        else if (m_iErrorLog)
        {
            CString csErrorSource,csErrorDescription,csNull = "";
            EXCEPINFO eiInfo;
            eiInfo.wCode = ADDIN_E_VERY_IMPORTANT;
            eiInfo.scode = S_OK;
            csErrorSource.LoadString(IDS_ERROR_SOURCE);
            eiInfo.bstrSource = csErrorSource.AllocSysString();
            csErrorDescription.LoadString(IDS_ERROR_DESCRIPTION);
            eiInfo.bstrDescription = csErrorDescription.AllocSysString();
            m_iErrorLog->AddError(csNull.AllocSysString(),&eiInfo);
        }

        break;
    case methStartTimer:
        pAsyncEvent = m_iAsyncEvent;
        m_uiTimer = ::SetTimer(NULL,0,100,MyTimerProc);
        break;
    case methStopTimer:
        if (m_uiTimer != 0) ::KillTimer(NULL,m_uiTimer);
        pAsyncEvent = NULL;
        break;
    case methOpenForm:
        {
            bool success = false;
            _variant_t var;
            HRESULT hr = m_iConnect.GetPropertyByName(L"AppDispatch", var.GetAddress());
            if (SUCCEEDED(hr))
            {
                ATLASSERT(V_VT(&var) == VT_DISPATCH);
                CComPtr<IDispatch> app = V_DISPATCH(&var);
                HRESULT hr = app.GetPropertyByName(L"", var.GetAddress());
                if (SUCCEEDED(hr))
                {
                    CComPtr<IDispatch> procs = V_DISPATCH(&var);
                    HRESULT hr = procs.GetPropertyByName(L"", var.GetAddress());
                    if (SUCCEEDED(hr))
                    {
                        _variant_t vars[3];
                        UUID id;
                        ::UuidCreate(&id);
                        BYTE* strId = NULL;
                        ::UuidToString(&id, &strId);
                        vars[0] = T2OLE((LPCTSTR)strId);
                        ::RpcStringFree(&strId);
                        V_VT(&vars[2]) = VT_ERROR;
                        V_VT(&vars[1]) = VT_ERROR;

                        CComPtr<IDispatch> proc = V_DISPATCH(&var);
                        HRESULT hr = proc.InvokeN(L"", vars, 3, var.GetAddress());
                        if (SUCCEEDED(hr))
                        {
                            CComPtr<IDispatch> form = V_DISPATCH(&var);
                            form.Invoke0(L"");
                            success = true;
                        }
                    }
                }
            }

            if (!success && m_iErrorLog)
            {
                CString csErrorSource,csErrorDescription,csNull = "";
                EXCEPINFO eiInfo;
                memset(&eiInfo, 0, sizeof EXCEPINFO);
                eiInfo.wCode = ADDIN_E_VERY_IMPORTANT;
                eiInfo.scode = S_OK;
                csErrorSource.LoadString(IDS_ERROR_SOURCE);
                eiInfo.bstrSource = csErrorSource.AllocSysString();
                csErrorDescription.LoadString(IDS_ERROR_OPENFORMERROR);
                eiInfo.bstrDescription = csErrorDescription.AllocSysString();
                m_iErrorLog->AddError(csNull.AllocSysString(),&eiInfo);
            }
        }
        break;
    default:
        return S_FALSE;
    }
    
    return S_OK;
}

STDMETHODIMP CAddIn::CallAsFunc(long lMethodNum,VARIANT *pvarRetValue,SAFEARRAY **paParams)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    return S_FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// IPropertyPage

/*STDMETHODIMP CAddIn::SetPageSite(IPropertyPageSite *pPageSite)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

	return S_OK;
}

STDMETHODIMP CAddIn::Activate(HWND hWndParent,LPCRECT prc,BOOL bModal)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

    return IPropertyPageImpl<CAddIn>::Activate(hWndParent,prc,bModal);
}*/

STDMETHODIMP CAddIn::Deactivate()
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    IPropertyPageImpl<CAddIn>::Deactivate();

    // Don't forget to detach controls!
    m_boxEnabled.Detach();

    return S_OK;
}

/*STDMETHODIMP CAddIn::GetPageInfo(PROPPAGEINFO *pPageInfo)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

	return S_OK;
}

STDMETHODIMP CAddIn::SetObjects(ULONG cObjects,IUnknown **ppUnk)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here
    
    return IPropertyPageImpl<CAddIn>::SetObjects(cObjects,ppUnk);
}

/*STDMETHODIMP CAddIn::Show(UINT nCmdShow)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

	return S_OK;
}

STDMETHODIMP CAddIn::Move(LPCRECT prc)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

	return S_OK;
}

STDMETHODIMP CAddIn::IsPageDirty()
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

	return S_OK;
}*/

STDMETHODIMP CAddIn::Apply()
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    BOOL boolEnabled;
    IPropertyLink *pLink = NULL;

    m_ppUnk[0]->QueryInterface(IID_IPropertyLink,(LPVOID *)&pLink);
    if (pLink != NULL)
    {
        boolEnabled = m_boxEnabled.GetCheck()?TRUE:FALSE;
        pLink->put_Enabled(boolEnabled);
        pLink->Release();
    }
    SetDirty(FALSE);

    return S_OK;
}

/*STDMETHODIMP CAddIn::Help(LPCOLESTR pszHelpDir)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here

	return S_OK;
}

STDMETHODIMP CAddIn::TranslateAccelerator(LPMSG pMsg)
{
	AFX_MANAGE_STATE(AfxGetStaticModuleState())

	// TODO: Add your implementation code here
    
	return S_OK;
}*/


LRESULT CAddIn::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
    IPropertyLink *pLink = NULL;
    m_ppUnk[0]->QueryInterface(IID_IPropertyLink,(LPVOID *)&pLink);

    if (pLink != NULL)
    {
        pLink->get_Enabled(&m_boolEnabled);        
        pLink->Release();
    }
    
    m_boxEnabled.Attach(GetDlgItem(IDC_ADDIN_STATUS));
    m_boxEnabled.SetCheck(m_boolEnabled?1:0);

    SetDirty(FALSE);
    m_pPageSite->OnStatusChange(0);
    bHandled = FALSE;

    return 0; 
}

LRESULT CAddIn::OnCommand(WORD wNotifyCode, WORD nID, HWND hWndCtl, BOOL& bHandled)
{
    SetDirty(TRUE);
    bHandled = FALSE;

    return 0;
}

/////////////////////////////////////////////////////////////////////////////
// IPropertyLink

STDMETHODIMP CAddIn::get_Enabled(BOOL *boolEnabled)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

   *boolEnabled = m_boolEnabled;

    return S_OK;
}

STDMETHODIMP CAddIn::put_Enabled(BOOL boolEnabled)
{
    AFX_MANAGE_STATE(AfxGetStaticModuleState())

    CString csSource(""),csMessage(""),csData;

    m_boolEnabled = boolEnabled;
    csData = boolEnabled?"1":"0";
    m_iAsyncEvent->ExternalEvent(csSource.AllocSysString(),
                                 csMessage.AllocSysString(),
                                 csData.AllocSysString());

    return S_OK;
}

VOID CALLBACK MyTimerProc(
  HWND hwnd,    // handle of window for timer messages
  UINT uMsg,    // WM_TIMER message
  UINT idEvent, // timer identifier
  DWORD dwTime  // current system time
)
{
    _bstr_t who, what, data;
    CString csSource(""),csMessage(""),csData;
    CTime tmCur = CTime::GetCurrentTime();
    csData = tmCur.Format("%H:%M:%S");
    if (pAsyncEvent)
    {
        who = csSource;
        what = csMessage;
        data = csData;
        pAsyncEvent->ExternalEvent(who, what, data);
    }
}
