#include <Core/Core.h>

using namespace Upp;

#include <Functions4U/Functions4U.h>
#include <OfficeAutomation/OfficeAutomation.h>

CONSOLE_APP_MAIN
{
	
	try
	{
	// TEST XLS
		
		OfficeSheet sheet;
			
		bool openAvailable = sheet.IsAvailable("Open");
		bool microsoftAvailable = sheet.IsAvailable("Microsoft");
		
		if(!openAvailable && !microsoftAvailable)
		{
			throw Exc("MS Office n'est pas pret, le programme ne peut pas lire le fichier Excel!!");	
		}
		
		if (openAvailable) 
		{
			sheet.Init("Open");
		}
		if (microsoftAvailable) 
		{
			sheet.Init("Microsoft");
		}
			
		String ficXLS = ConfigFile("test.xls");
		
		if (!sheet.OpenSheet(ficXLS, false)) 
		{
			sheet.AddSheet(true);
			
			if(sheet.InsertTab("My new tab"))
				sheet.SetValue(3, 21, "Hello");
			
			sheet.SaveAs(ficXLS, "xls");
			sheet.Quit();
		}

	}
	catch(Exc &e)
	{
		Cout() << e;	
	}

}

