#ifndef _RegExp_RegExp_h_
#define _RegExp_RegExp_h_

#include <Core/Core.h>
#include <RegExp/pcre/pcre.h>

#define _OPT 30

enum PCRE_Options{
	CASELESS		=	PCRE_CASELESS,
	MULTILINE		=	PCRE_MULTILINE,
	DOTALL			=	PCRE_DOTALL,
	EXTENDED		=	PCRE_EXTENDED,
	ANCHORED		=	PCRE_ANCHORED,
	DOLLAR_ENDONLY	=	PCRE_DOLLAR_ENDONLY,
	EXTRA			=	PCRE_EXTRA,
	NOTBOL			=	PCRE_NOTBOL,
	NOTEOL			=	PCRE_NOTEOL,
	UNGREEDY		=	PCRE_UNGREEDY,
	NOTEMPTY		=	PCRE_NOTEMPTY,
	UTF8			=	PCRE_UTF8,
	NO_AUTO_CAPTURE	=	PCRE_NO_AUTO_CAPTURE,
	NO_UTF8_CHECK	=	PCRE_NO_UTF8_CHECK,
	AUTO_CALLOUT	=	PCRE_AUTO_CALLOUT,
	PARTIAL			=	PCRE_PARTIAL,
	DFA_SHORTEST	=	PCRE_DFA_SHORTEST,
	DFA_RESTART		=	PCRE_DFA_RESTART,
	FIRSTLINE		=	PCRE_FIRSTLINE,
	DUPNAMES		=	PCRE_DUPNAMES,
	NEWLINE_CR		=	PCRE_NEWLINE_CR,
	NEWLINE_LF		=	PCRE_NEWLINE_LF,
	NEWLINE_CRLF	=	PCRE_NEWLINE_CRLF,
};

class RegExpOptions{
	int opt;
public:
	RegExpOptions()						{ opt = 0; }
	RegExpOptions(PCRE_Options o)		{ opt = 0; opt |= o; }
	int operator~()						{ return opt; }
	RegExpOptions& operator()(PCRE_Options o, bool b = true){
		return Set(o, b); 
	}
	RegExpOptions& Set(PCRE_Options o, bool b){
		if(b) opt |= o;
		else opt &= ~o;
		return *this;
	}
};

class RegExp{
public:
	RegExp				();
	RegExp				(const String& s);
	RegExp				(const String& s, RegExpOptions o);
	~RegExp				();
	
	void SetPattern		(const String& s);
	void SetOptions		(RegExpOptions o);
	void ClearOptions	();
	void SetString		(const String& txt);

	String GetPattern	()	{ return pattern; }
	int GetOptions		()	{ return pattern_options; }
	int GetOffset		()	{ return current_position; }
	void ClearOffset	()	{ current_position = 0; }
	String GetError		()	{ return error; }//+erroffset
	String GetExecError	();
	
	/*Vector<int> GetIndexes(){
		Vector<int> res;
		for (int i = 0; i < rc; i++)
			res << ovector[2*i]
				<< ovector[2*i+1];
		return res;
	}*/
	bool IsMatch		(const String& txt);
	bool Next			();
	Vector<Value> Get	();

	Vector<Value> GetMatches(const String& txt);
	String Replace		(const String& txt, const String &str);
	
	void operator =		(RegExp &r);

private:
	bool exec			(int offset=0,int options=0);
	void compile		();
	void match_all		(Vector<Value> &v);
	void replace_all	(const String &str, String &result);
	
	int pattern_options;
	int current_position;
	String pattern;
	pcre *re;
	const char *error;
	int erroffset;
	int rc;
	int ovector[_OPT];
	String text;
};

template<class T>
bool operator == (RegExp &re, const T &s)	{ return re.IsMatch(AsString(s)); }

template<class T>
bool operator == (const T &s, RegExp &re)	{ return re.IsMatch(AsString(s)); }


#undef _OPT

#endif
