#include <SqlCtrl/SqlCtrl.h>
#include <plugin/sqlite3/Sqlite3.h>
#include "converts.h"
using namespace Upp;

#define MODEL <SqlArray2/db.sch>

#define SCHEMADIALECT <plugin/sqlite3/Sqlite3Schema.h>
#include "Sql/sch_header.h"

#define SCHEMADIALECT <plugin/sqlite3/Sqlite3Schema.h>
#include "Sql/sch_source.h"

#define SCHEMADIALECT <plugin/sqlite3/Sqlite3Schema.h>
#include "Sql/sch_schema.h"

#define LAYOUTFILE <SqlArray2/app.lay>
#include <CtrlCore/lay.h>


struct App : public WithAppLayout<TopWindow> {
	EditString author;
	EditString title;
    DropList country;
	typedef App CLASSNAME;
	void DropStart() {
		if(master.Get(COUNTRY).IsNull()) master.Set(COUNTRY,12);
	}

	App() {
		CtrlLayout(*this, "SqlArray SQL table editing example");
		
		SQL * Select(SqlAll()).From(COUNTRY_T);
		while(SQL.Fetch()) {
			country.Add(SQL[0],SQL[1]);
		}
		
		
		
		master.SetTable(BOOK);
		master.AddKey(ID);
		master.AddColumn(AUTHOR, "Author").Edit(author);
		master.AddColumn(TITLE, "Title").Edit(title);
		// Example using Lookup MACRO: Lookup(table,keyfield,valuefield) or may simpleuse
		master.AddColumn(COUNTRY, "Country").SetConvert(Single<Lookup(COUNTRY_T,COU_ID,COU_NAME)>()).Edit(country);
		// or may simpleuse:
		//master.AddColumn(COUNTRY, "Country").SetConvert(Single<LookupCOUNTRY_TCOU_IDCOU_NAME>()).Edit(country);
		master.Appending().Removing();
		master.SetOrderBy(AUTHOR, TITLE);
		master.WhenStartEdit =THISBACK(DropStart);

        
		master.Query();
	}
};

GUI_APP_MAIN
{
	Sqlite3Session sqlite3;
	if(!sqlite3.Open(ConfigFile("simple.db"))) {
		Exclamation("Can't create or open database file\n");
		return;
	}
	SQL = sqlite3;
	SqlSchema sch(SQLITE3);
	sqlite3.SetTrace();
	All_Tables(sch);
	if(sch.ScriptChanged(SqlSchema::UPGRADE))
		Sqlite3PerformScript(sch.Upgrade());
	if(sch.ScriptChanged(SqlSchema::ATTRIBUTES))
		Sqlite3PerformScript(sch.Attributes());
	if(sch.ScriptChanged(SqlSchema::CONFIG)) {
		Sqlite3PerformScript(sch.ConfigDrop());
		Sqlite3PerformScript(sch.Config());
	}
	sqlite3.SetTrace();
	
	// Only for test application:
	//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
	SQL * SqlSelect(Count(COU_ID)).From(COUNTRY_T);
	SQL.Fetch();
	if ((int)SQL[0] <= 0){
		SQL * Insert(COUNTRY_T)(COU_ID,12)(COU_NAME,"Russia");
		SQL * Insert(COUNTRY_T)(COU_ID,24)(COU_NAME,"Czech Republic");
		SQL * Insert(COUNTRY_T)(COU_ID,31)(COU_NAME,"Italy");
	}
	//^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	App().Run();
}
