#include "TestMDI.h"

MainWind::MainWind()
{
	AddFrame(menu);
	menu.Set(THISBACK(MainMenu));
}

void MainWind::FileNew()
{
	(new ChildWind)->Open();
}

void MainWind::FileOpen()
{
	FileSel dlg;
	dlg.Type("plain text files","*.txt");
	dlg.Type("Any source files","*.cpp *.c");
	dlg.Type("Header files","*.h");
	dlg.Type("Any files","*.*");
	dlg.ActiveDir(GetCurrentDirectory());
	
	if(!dlg.ExecuteOpen())return;
	
	//CUtils::SetCurrentDirectory_(dlg.GetActiveDir());
		
	String filename = ~dlg;
	OpenS(filename);
}

void MainWind::OpenS(String fn)
{
	ChildWind* chd = new ChildWind;
	
	FileIn infile;
	if(!infile.Open(fn)) return;
	chd->Open();
	chd->m_doc.Load(infile);
	chd->Title(fn);
}

void MainWind::WindowCloseAll()
{
	Vector<Ctrl*> windowlist;
	windowlist = GetTopWindows();
	for(int i=0;i<windowlist.GetCount();i++)
	{
		if(windowlist[i]->GetOwner() == NULL)
			continue;
		else
			windowlist[i]->Close();
	}

}
ChildWind::ChildWind()
{
	CtrlLayout(*this,Format("Untitled%d",++i));
	MaximizeBox().MinimizeBox().Sizeable();
}

void ChildWind::Layout()
{
	// to do: resize child ctrls
	m_doc.SizePos();
}



GUI_APP_MAIN
{
	Vector<ChildWind*> windowlist;
	MainWind app;
	app.Title("Test MDI").MaximizeBox().MinimizeBox().Sizeable().OpenMain();
	Ctrl::EventLoop();
}

