#include <CtrlLib/CtrlLib.h>
#include <DropGrid/DropGrid.h>

using namespace Upp;

void SetupArray(ArrayCtrl& array, EditString& name, DropGrid& drop);

GUI_APP_MAIN
{
	TopWindow win;
	EditString name;
	DropGrid drop;
	ArrayCtrl array;
	
	SetupArray(array, name, drop);
	
	win.Add(array);
	
	
	win.Run();
}

const char * choices[]={
	"Apple",
	"Orange",
	"Grape",
	"Banana",
	"Mango",
	"Strawberry",
	"Passion Fruit"
};

int FruitToIndex(const char *fruit)
{
	for(int i=0; i<sizeof(choices)/sizeof(choices[0]); ++i)
		if(stricmp(fruit,choices[i])==0)
			return i;
	return Null;
}

struct ConvertChoice : public Convert
{
	virtual Value  Format(const Value& q) const
	{
		if(q.Is<int>())
		{
			int i=q;
			if(i>0 && i<sizeof(choices)/sizeof(choices[0]))
				return String(choices[i]);
		}
		return String();
		
	}
	virtual Value  Scan(const Value& text) const
	{
		return FruitToIndex(String(text));
	}
	
};

static ConvertChoice conv;

void SetupArray(ArrayCtrl& array, EditString& name, DropGrid& drop)
{
	array.AppendLine().Appending().SizePos();
	array.AddColumn("Name").Edit(name);
	array.AddColumn("Choice").SetConvert(conv).Edit(drop);
	
	drop.AddColumn("ID");
	drop.AddColumn("Fruit");
	for(int i=0; i<sizeof(choices)/sizeof(choices[0]); ++i)
	{
		drop.Add(i, choices[i]);
		
	}
	drop.SetValueColumn(1);
}