#include "trayiconeV2.h"

#define IMAGECLASS mytrayicone2
#define  IMAGEFILE <TESTs/trayiconeV2/tray2.iml>
#include <Draw/iml.h>


trayiconeV2::trayiconeV2()
{	
	CtrlLayout(*this, "Window title");
	Zoomable();
	Sizeable();
	CenterScreen();
	
	trayicon.Icon(mytrayicone2::icone());
	
	trayicon.WhenBar = THISBACK(TrayMenu);
	trayicon.WhenLeftDouble = THISBACK(Launch);
	trayicon.Tip(t_("Mon TrayIcon Test"));
	
	WhenClose = THISBACK(fermer);
	WhenMinimize = THISBACK(cacher);
	
	isMinimized = false;
}

// implementation of WndProc
LRESULT trayiconeV2::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	if (message == WM_SYSCOMMAND && wParam == SC_MINIMIZE)
	{
		WhenMinimize(); // callback
		return 0;
	}
	return TopWindow::WindowProc(message, wParam, lParam);
}

void trayiconeV2::TrayMenu(Bar& bar)
{
	bar.Add(t_("Afficher"), THISBACK(Launch));
	bar.Add(t_("Réduire"), THISBACK(cacher))
	   .Check(!isMinimized);
	bar.Add(t_("Fermer"), THISBACK(fermer));	
	
}

void trayiconeV2::Launch()
{
	Show();	
	isMinimized = false;
}

void trayiconeV2::cacher()
{
	isMinimized = true;
	Hide();		
}

void trayiconeV2::fermer()
{
	Break();
	trayicon.Break();		
}

GUI_APP_MAIN
{
	trayiconeV2().Run();
}

