#include "trayiconeV3.h"

trayiconeV3::trayiconeV3()
{
	CtrlLayout(*this, "Window title");
	Zoomable();
	Sizeable();
	CenterScreen();
	
	// By default
	isMinimized = false;	
	WhenMinimize = THISBACK(cacher);
				
	traybar.Set(THISBACK(TrayBar));
	//trayicon.WhenBarMouseLeft = THISBACK(TrayBar);	
	trayicon.WhenBarMouseLeft = THISBACK(TrayBar);	
	trayicon.WhenLeftDouble = THISBACK(lancer);		
}

// implementation of WndProc
LRESULT trayiconeV3::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	if (message == WM_SYSCOMMAND && wParam == SC_MINIMIZE)
	{
		WhenMinimize(); // our new callback
		return 0;
	}
		
	return TopWindow::WindowProc(message, wParam, lParam);
}

void trayiconeV3::TrayBar(Bar& bar)
{
	bar.Add(CtrlImg::new_doc(), callback1(Exclamation, "Hello!"));
	bar.Add(t_("Afficher"), THISBACK(lancer));
	bar.Add(t_("Réduire"), THISBACK(cacher)).Check(!isMinimized);
	bar.Add(t_("Fermer"), THISBACK(fermer));
}

void trayiconeV3::cacher()
{
	isMinimized = true;
	
	PromptOK("La fenetre est réduite");
	Hide();		
}

void trayiconeV3::lancer()
{
	Show();	
	isMinimized = false;	
}

void trayiconeV3::fermer()
{
	Break();
	trayicon.Break();		
}

GUI_APP_MAIN
{
	trayiconeV3().Run();
}

