#include "testapp.h"
#include <string>
#include <vector>

using namespace std;

vector<string> split(const string &s, const char *by = " \t\r\n") {
	vector<string> res;
	int i, j, n = s.size();
	for (i = 0; i <= n; i = j + 1) {
		for (j = i; j < n && strchr(by, s[j]) == NULL;) j++;
		res.push_back(s.substr(i, j-i));
	}
	return res;
}

int pureValue (string traff) {
	int res;
	vector<string> val = split (traff);
	if (val[1] == "MiB") res = atol (val[0].c_str()) * 1024;
	else if (val[1] == "GiB") res = atol (val[0].c_str()) * 1048575;
	else res = atoi (val[0].c_str());
	return res;
}

int cmpv(const Value& row1, const Value& row2)
{
	//MessageBoxA (0, String(row1) + " " + String(row2), "", 0);
	if (pureValue (String(row1)) > pureValue (String(row2))) 
	{
		//MessageBoxA (0, String(row1) + " " + String(row2), "row1 > row2", 0);
		return 0;
	} else return 1;
}

testapp::testapp()
{
	CtrlLayout(*this, "Window title");
	Table.AddColumn("0", "Domain").Sorting();
	Table.AddColumn("1", "Traffic").Sorting(cmpv);
	Table.Add ("test.com", "10 MiB");
	Table.Add ("google.ru", "500 KiB");
	Table.Add ("yahoo.com", "1 GiB");
}

GUI_APP_MAIN
{
	testapp().Run();
}

