#include <Core/Core.h>
#include "CCharge.h"

using namespace Upp;

class CCalendrier
{
	public :	
	
		// My VectorMap to serialize	
		VectorMap<Date, CCharge *> 	vPaiementComptant;	
			
				
		void Serialize(Stream& s);
		CCalendrier& operator<< (CCharge& oCharge){};
		CCalendrier(){};
		~CCalendrier(){};
};

void CCalendrier::Serialize(Stream& s)
{		
	int k = vPaiementComptant.GetCount();
	for(int i=0; i<k; i++)
	{
		Date dt 		= vPaiementComptant.GetKey(i);
		CCharge *oCharge = vPaiementComptant.Get(dt);
		
		s % dt.day;
		s % dt.month;
		s % dt.year;
		
		// is it valide both on storage and load
		s % (*oCharge);  
		
	}				
}

CONSOLE_APP_MAIN
{
	
		Cout() << "\tVectorMap Serialisation sample";
		Cout().PutEol();
		Cout() << "\t------------------------------";
		Cout().PutEol();
		Cout().PutEol();
		
	Date dt = GetSysDate();
	
	////////////////////////////////////////////////////////
	
		CCalendrier oCalendrier, oCalendrier2;	
		Cout() << "\tOK Object CCalendrier oCalendrier and oCalendrier2 created";
		
		Cout().PutEol();
		
	
	/////////////////////////////////////////////////////////
	
		CCharge *oCharge = new CCharge();
		oCharge->m_Libelle = "test";
		Cout() << "\tOK Object CCharge *oCharge created";
		
		Cout().PutEol();
	
	
	/////////////////////////////////////////////////////////
	
		oCalendrier.vPaiementComptant.Add(dt,oCharge);
		dt = oCalendrier.vPaiementComptant.GetKey(0);
		if(IsDateTime(dt))
			Cout() << "\tOK <dt,*oCharge> added to VectorMap member of oCalendrier, date = " << dt;
		else
			Cout() << "\tERROR : Can't add <dt,*oCharge> to VectorMap member of oCalendrier";
		
		Cout().PutEol();
	
	
	/////////////////////////////////////////////////////////
	
		if(StoreToFile(oCalendrier, "test.txt"))
			Cout() << "\tOK Object CCalendrier stored in file test.txt";
		else
			Cout() << "\tERROR : Can't store Object CCalendrier in file test.txt";
		
		Cout().PutEol();
	
	
	/////////////////////////////////////////////////////////

		if(LoadFromFile(oCalendrier2, "test.txt"))
		{
			dt = oCalendrier2.vPaiementComptant.GetKey(0);
			Cout() << "\tOK Object CCalendrier loaded in oCalendrier2 from file test.txt, date = " << dt;
		}
		else 
			Cout() << "\tERROR : Can't load an Object CCalendrier from file test.txt";
			
		Cout().PutEol();
}
