#ifndef _TESTs_CachManag_ctrContainer_h_
#define _TESTs_CachManag_ctrContainer_h_


#include <CtrlLib/CtrlLib.h>
#include "ctrlContent.h"

using namespace Upp;

struct CtrlContainer : public Ctrl
{
	typedef CtrlContainer CLASSNAME;
	
	public : 
	
		Rect rectEntier;
		
		Drawing borderddrawing;
		Rect rectborder; // C'est le rectangle qui contient la bordure, coord relatives
		
		bool isMouseEnter;
		Drawing contentdrawing;
		Rect rectcontent;
		String text;
		
		Vector<CtrlContent *> vContents;
		CtrlContent oContentdefault;
		
		virtual void Paint(Draw& w) 
		{
			w.DrawRect(rectEntier, White());
			w.DrawDrawing(rectborder, borderddrawing);
			w.DrawText(50, 50, text, Arial(20), Magenta);
			
			if(isMouseEnter)
				w.DrawDrawing(rectcontent, contentdrawing);			
		}
		
		
		virtual void MouseMove(Point p, dword keyflags)
		{
			isMouseEnter = true;
			text = Format("[%d:%d]", p.x, p.y);
			Refresh();
		}
		
		bool AddContent(CtrlContent& oContent)
		{
			oContent.SetRect(55,55,50,50);
			Add(oContent);
			PromptOK("OK: adding oContent to CtrlContent");
					
			oContent.Refresh();	
			oContent.RefreshLayout();
			oContent.RefreshParentLayout();
							
			Refresh();
			RefreshLayout();
			RefreshParentLayout();
			
			PromptOK("OK: refreshing CtrlContent, CtrlContainer, layouts and parent layouts");
			
			return true;
		}
		
		CtrlContainer& operator= (const CtrlContainer& oContainer)
		{
			borderddrawing 	= oContainer.borderddrawing;
			contentdrawing 	= oContainer.contentdrawing;
			isMouseEnter   	= oContainer.isMouseEnter;
			rectEntier 		= oContainer.rectEntier;
			rectborder 		= oContainer.rectborder;
			rectcontent		= oContainer.rectcontent;
			text			= oContainer.text;
		
			return *this;	
		}
		
		CtrlContainer()
		{
			isMouseEnter = false;
			
			int wdrw = 500;
			int hdrw = 500;
			
			rectEntier.Set(0,0,wdrw,hdrw);
			
		// Border
		
			DrawingDraw ddborder(wdrw, hdrw);
			ddborder.DrawLine(0, 0, 15, 0);
			ddborder.DrawLine(wdrw-6, 0, wdrw-1, 0);
			
			ddborder.DrawLine(wdrw-1, 0, wdrw-1, 15);
			ddborder.DrawLine(wdrw-1, hdrw-16, wdrw-1, hdrw-1);
			
			ddborder.DrawLine(wdrw-1, hdrw-1, wdrw-16, hdrw-1);
			ddborder.DrawLine(5, hdrw-1, 0, hdrw-1);
			
			ddborder.DrawLine(0, hdrw-1, 0, hdrw-16);
			ddborder.DrawLine(0, 15, 0, 0);
			
			borderddrawing = ddborder;
			
			rectborder.Set(0, 0, wdrw, hdrw);
			
		// Contenu
		
			DrawingDraw dd(50, 50);	
			Font font = CourierZ(12);	
			dd.DrawText(2, 2, "essai", font);
					
			contentdrawing = dd;
	
			Size sz = contentdrawing.GetSize();
			rectcontent.Set(2, 2, 2+sz.cx, 2+sz.cy);

		// Content

			oContentdefault.Afficher("default");
			oContentdefault.SetRect(10,100,50,50);
			Add(oContentdefault);
			Refresh();
		};

		CtrlContainer(CtrlContainer& oContainer)
		{
			*this = oContainer;
		}
		
		~CtrlContainer(){};
};

#endif
