#ifndef _TESTs_CachManag_ctrlContent_h_
#define _TESTs_CachManag_ctrlContent_h_

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

struct CtrlContent : public Ctrl
{
	typedef CtrlContent CLASSNAME;
	
	public : 
	
		bool isdrawborder;
		Drawing drawing;
		Drawing borderdrw;
		//Color mycolor;
		Point relatifInnerMousePos;
		int wdrw;
		int hdrw;
		Image img;
		
		Rect rectdrw; // C'est le rectangle qui contient l'écriture, coord relatives
		Rect rectborderdrw; // C'est le rectangle qui contient la bordure, coord relatives
		
		Callback WhenCtrlMoved;
		String m_label;
		
		virtual void Paint(Draw& w) 
		{
			w.DrawDrawing(rectdrw, drawing);
			w.DrawImage(0, 0, img);
			
			if(isdrawborder)
				w.DrawDrawing(rectborderdrw, borderdrw);
		}
		
		virtual void LeftDown(Point p, dword flags)
		{					
			isdrawborder = true;
			//mycolor = GrayColor(220);
			
			//Refresh(); img ne l'aime pas!!!
			
			// Calcul 
			
			Rect rect = GetRect();
			p = GetMousePos();
			
			relatifInnerMousePos.x = p.x - rect.left;
			relatifInnerMousePos.y = p.y - rect.top;
	
		}
		
		virtual void MouseMove(Point p, dword flags)
		{
			if(isdrawborder)
			{
				p = GetMousePos();
				Size sz = GetSize();		
				
				int ex = relatifInnerMousePos.x;
				int ey = relatifInnerMousePos.y;
				
				SetRect(p.x - ex, p.y - ey, sz.cx, sz.cy);
				
				RefreshParentLayout();
			}
		}
		
		virtual void LeftUp(Point p, dword flags)
		{				
			isdrawborder = false;
			//Refresh();
						
			WhenCtrlMoved();
		}
		
		void Afficher(const String& label)
		{
		
		// Fond
		
			ImageBuffer ib(50, 50);
			for(int y = 0; y < 50; y++) 
			{
				RGBA *l = ib[y];
				for(int x = 0; x < 50; x++) {
					if(y == 0 || y == 49 || x == 0 || x == 49)
						*l++ = White();
					else {
						l->a = 1.2 * (x + y);
						l->r = 4 * x;
						l->g = 4 * y;
						l->b = 210;
						l++;
					}
				}
			}
			Premultiply(ib);
			img = ib;
			
		// Contenu
		
			m_label = label;
			
			DrawingDraw dd(50, 50);	
			Font font = CourierZ(12);	
			dd.DrawText(2, 2, m_label, font);
					
			drawing = dd;
	
			Size sz = drawing.GetSize();
			rectdrw.Set(2, 2, 2+sz.cx, 2+sz.cy);
			
		// Bordure
		
			wdrw = sz.cx+4;
			hdrw = sz.cy+4;
			DrawingDraw ddborder(wdrw, hdrw);
		
			ddborder.DrawLine(0, 0, 5, 0);
			ddborder.DrawLine(wdrw-6, 0, wdrw-1, 0);
			
			ddborder.DrawLine(wdrw-1, 0, wdrw-1, 5);
			ddborder.DrawLine(wdrw-1, hdrw-6, wdrw-1, hdrw-1);
			
			ddborder.DrawLine(wdrw-1, hdrw-1, wdrw-6, hdrw-1);
			ddborder.DrawLine(5, hdrw-1, 0, hdrw-1);
			
			ddborder.DrawLine(0, hdrw-1, 0, hdrw-6);
			ddborder.DrawLine(0, 5, 0, 0);
			
			borderdrw = ddborder;
			rectborderdrw.Set(0, 0, wdrw, hdrw);
		}
		
		CtrlContent()
		{
			Afficher(m_label);
			isdrawborder = false;
		}
		
		CtrlContent(const String& label)
		{ 
			m_label = label;
			Afficher(m_label);
			isdrawborder = false;
		}
		
		~CtrlContent(){}
};

#endif
