#include "TestMDI.h"

MainWind::MainWind()
{
	AddFrame(menu);
	menu.Set(THISBACK(MainMenu));
}

void MainWind::FileNew()
{
	ChildWind* p = new ChildWind;
	p->Style(WS_CHILD|WS_VISIBLE|WS_OVERLAPPEDWINDOW|WS_CLIPSIBLINGS);
	windowlist.Add(p);
	p->Open();
}

void MainWind::FileOpen()
{
	FileSel dlg;
	dlg.Type("plain text files","*.txt");
	dlg.Type("Any source files","*.cpp *.c");
	dlg.Type("Header files","*.h");
	dlg.Type("Any files","*.*");
	dlg.ActiveDir(GetCurrentDirectory());
	
	if(!dlg.ExecuteOpen())return;
	
	//CUtils::SetCurrentDirectory_(dlg.GetActiveDir());
		
	String filename = ~dlg;
	OpenS(filename);
}

void MainWind::OpenS(String fn)
{
	ChildWind* chd = new ChildWind;
	windowlist.Add(chd);
	FileIn infile;
	if(!infile.Open(fn)) return;
	chd->Style(WS_CHILD|WS_VISIBLE|WS_OVERLAPPEDWINDOW|WS_CLIPSIBLINGS).Open();
	chd->m_doc.Load(infile);
	chd->Title(fn);
}

void MainWind::WindowCloseAll()
{
	for(int i=0;i<windowlist.GetCount();i++)
	{
		windowlist[i]->Close();
	}
	windowlist.Clear();
}
ChildWind::ChildWind()
{
	CtrlLayout(*this,Format("Untitled%d",++i));
	MaximizeBox().MinimizeBox().Sizeable();
}

void ChildWind::Layout()
{
	// to do: resize child ctrls
	m_doc.SizePos();
}



GUI_APP_MAIN
{
	MainWind app;
	app.Title("Test MDI").MaximizeBox().MinimizeBox().Sizeable().OpenMain();
	Ctrl::EventLoop();
}

