
#include "SystemDraw.h"
//#include "ConsoleDraw.h"

NAMESPACE_UPP

#ifdef PLATFORM_COCOA

extern String lllg;
//#define LLOG(x)   lllg=""; \
//LOG(x)\

//NSLog(@"%s",(const char*)lllg);
#define LLOG(x) LOG(x)


struct Image::Data::SystemData {
//	LPCSTR      cursor_cheat;
	CGImageRef     hbmp;
	CGImageRef     hmask;
	CGImageRef     himg;
	RGBA       *section;
};

Image::Data::SystemData& Image::Data::Sys() const
{
	ASSERT(sizeof(system_buffer) >= sizeof(SystemData));
	return *(SystemData *)system_buffer;
}

//void SystemDraw::DrawImageOp(int x, int y, int cx, int cy, const Image& img, const Rect& src, Color color)
//{
//	CGContextDrawImage(context, CGRectMake(0, 0, width, height), imgRef); 
//}




int  Image::Data::GetResCountImp() const
{
	return 0; //!!Sys().picture + !!Sys().picture8;
}

ImageDraw::ImageDraw(int cx, int cy)
{
	LLOG("DRAW IMAGE MAC ImageDraw::ImageDraw(int cx, int cy) 1 cx="<<cx<<" cy="<< cy);	
	size = Size(cx, cy);
	Init();
	LLOG("DRAW IMAGE MAC ImageDraw::ImageDraw(int cx, int cy) 2 cx="<<size.cx<<" cy="<< size.cy);	

}

void ImageDraw::Section::Init(int cx, int cy)
{
	GuiLock __;
//	dc = ::CreateCompatibleDC(ScreenHDC());
//	dc = ScreenHDC();
//	CGFloat width = CGRectGetWidth(rect);
//    CGFloat height = CGRectGetHeight(rect);
    CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceRGB();
    
    size_t bitsPerComponent = 8;
    size_t bytesPerPixel    = 4;
    size_t bytesPerRow      = (cx * bitsPerComponent * bytesPerPixel + 7) / 8;
    size_t dataSize         = bytesPerRow * cy;
    
    unsigned char *data = (unsigned char*)malloc(dataSize);
    memset(data, 0, dataSize);
	
    //CGContextRef context
		LLOG("DRAW IMAGE MAC ImageDraw::Section::Init !!!!!!!!!!! 1");
	dc= CGBitmapContextCreate(data,
							  //(void **)&pixels,
							  cx, cy, 
												 bitsPerComponent, 
												 bytesPerRow, colorSpace, 
												 kCGImageAlphaPremultipliedLast | kCGBitmapByteOrder32Big);
	LLOG("DRAW IMAGE MAC ImageDraw::Section::Init !!!!!!!!!!! 2");
	
	// a drawing for a test.
    CGContextSetRGBFillColor (dc, 1, 0, 0, 1);
    CGContextFillRect (dc, CGRectMake (0, 0, 20, 10 ));
    CGContextSetRGBFillColor (dc, 0, 0, 1, .5);
    CGContextFillRect (dc, CGRectMake (0, 20, 10, 20));
    
    CGColorSpaceRelease(colorSpace);
    hbmp = CGBitmapContextCreateImage(dc);
//    rgb = CGBitmapContextCreateImage(dc);
    
	free(data); //?
	
//	BitmapInfo32__ bi(cx, cy);
//	hbmp = CreateDIBSection(dc, bi, DIB_RGB_COLORS, (void **)&pixels, NULL, 0);
//	hbmpOld = (HBITMAP) ::SelectObject(dc, hbmp);
}

ImageDraw::Section::~Section()
{
	GuiLock __;
//	::DeleteObject(::SelectObject(dc, hbmpOld));
//	::DeleteDC(dc);
	LLOG("ImageDraw::Section::~Section() CGContextRelease");	
	CGContextRelease(dc);
	//dc = NULL; //?
}

void ImageDraw::Init()
{
	GuiLock __;
	LLOG("DRAW IMAGE MAC ImageDraw::Init() --rgb cx="<<size.cx<<" cy="<< size.cy );	
	rgb.Init(size.cx, size.cy);
	LLOG("DRAW IMAGE MAC ImageDraw::Init() --a 2");	
	a.Init(size.cx, size.cy);
	
	LLOG("DRAW IMAGE MAC ImageDraw::Init() atach rgb 3");		
	Attach(rgb.dc);
	InitClip(size);
	LLOG("DRAW IMAGE MAC ImageDraw::Init() atach alpha 3");	
	alpha.Attach(a.dc);
	alpha.InitClip(size);
	LLOG("DRAW IMAGE MAC ImageDraw::Init() END");	

	has_alpha = false;
}


ImageDraw::ImageDraw(Size sz)
{
	size = sz;
	Init();
}

ImageDraw::operator Image() const
{
	return Get(true);
}

ImageDraw::~ImageDraw()
{
	Detach();
	alpha.Detach();
}


void Image::Data::SysInitImp()
{
	SystemData& sd = Sys();
	sd.hbmp = sd.hmask = sd.himg = NULL;
//	sd.cursor_cheat = NULL;
}

void Image::Data::SysReleaseImp()
{
	
}

void Image::Data::PaintImp(SystemDraw& w, int x, int y, const Rect& src, Color c)
{

	LLOG("Image::Data::PaintImp !!!!!!!!!!!");	
	
}

Image ImageDraw::Get(bool pm) const
{
		LLOG("ImageDraw::Get(bool pm) return Null; !!!!!!!!!!! cx="<<size.cx<<" cy="<< size.cy);
//#if 0		
	ImageBuffer b(size);
	int n = size.cx * size.cy;
	memcpy(~b, rgb.pixels, n * sizeof(RGBA)); //was orig
//	memcpy(~b, .pixels, n * sizeof(RGBA));
	LLOG("ImageDraw::Get(bool pm ) 1");
	const RGBA *s = a.pixels;
	const RGBA *e = a.pixels + n;
	RGBA *t = b;
	if(has_alpha) {
		while(s < e) {
			t->a = s->r;
			t++;
			s++;
		}
		if(pm)
			Premultiply(b);
		b.SetKind(IMAGE_ALPHA);
	}
	else {
		while(s < e) {
			t->a = 255;
			t++;
			s++;
		}
		b.SetKind(IMAGE_OPAQUE);
	}
	return b;
//#endif
//	return Null;
}

#define IMAGECLASS CtrlCoreImg
#define IMAGEFILE <CtrlCoreCoc/Ctrl.iml>
#include <Draw/iml_header.h>

//#define FCURSOR_(x) { Image h; INTERLOCKED { static Image m = sX11Cursor__(x); h = m; } return h; }

Image Image::Arrow() { return Null; }
Image Image::Wait() { return Null; }
Image Image::IBeam() { return Null; }
Image Image::No() { return Null; }
Image Image::SizeAll() { return Null; }
Image Image::SizeHorz() { return Null; }
Image Image::SizeVert() { return Null; }
Image Image::SizeTopLeft() { return Null; }
Image Image::SizeTop() { return Null; }
Image Image::SizeTopRight() { return Null; }
Image Image::SizeLeft() { return Null; }
Image Image::SizeRight() { return Null; }
Image Image::SizeBottomLeft() { return Null; }
Image Image::SizeBottom() { return Null; }
Image Image::SizeBottomRight()  { return Null; }
Image Image::Cross() { return Null; }
Image Image::Hand() { return CtrlCoreImg::DndMove(); }  //tmp


#endif

END_UPP_NAMESPACE