#include "multilang.h"

//#define IMAGEFILE <multilang/multilang.iml>
//#include <Draw/iml_source.h>



void multilang::InitDisplay()
{
	CtrlLayout(*this, "English ");
    
	btnLables[0][0] = 	"MENU ITEM 1" ;
	btnLables[0][1] = 	"MENU ITEM 2";
	btnLables[0][2] = 	"MENU ITEM 3";

	btnLables[1][0] = 	"मराठी मेनु १";
	btnLables[1][1] = 	"मराठी मेनु २";
	btnLables[1][2] = 	"मराठी मेनु ३";

	btnLables[2][0] = 	"  ಕನ್ನಡ ಮೆನು ೧";
	btnLables[2][1] = 	"  ಕನ್ನಡ ಮೆನು ೨";
	btnLables[2][2] = 	"  ಕನ್ನಡ ಮೆನು ೩";
	
	btnKannada.SetLabel("ಕರ್ನಾಟಕ");
	btnEnglish.SetLabel("English");
	btnMarathi.SetLabel("महाराष्ट्र");
	
	Add(btnEnglish.LeftPosZ(10, 100).TopPosZ(60, 25));
	Add(btnMarathi.LeftPosZ(120, 100).TopPosZ(60, 25));
	Add(btnKannada.LeftPosZ(230, 100).TopPosZ(60, 25));

	Add(btnMenu1.LeftPosZ(10, 100).TopPosZ(10, 25));
	Add(btnMenu2.LeftPosZ(120, 100).TopPosZ(10, 25));
	Add(btnMenu3.LeftPosZ(230, 100).TopPosZ(10, 25));

	btnEnglish <<= THISBACK1(Click,0);
	btnMarathi <<= THISBACK1(Click,1);
	btnKannada <<= THISBACK1(Click,2);

	Sizeable().Zoomable();
	
};

void multilang::Click(int Lang) 
{
		switch ( Lang )
	{
		case 0 :
			Draw::SetStdFont(fntEnglish);
			Title(" English ");
			break;
		case 1 :
			Draw::SetStdFont(fntMarathi);
			Title(" महाराष्ट्र ");
			break ;
		case 2 :
			Draw::SetStdFont(fntKannada);
			Title(" ಕರ್ನಾಟಕ");
			break ;
		default :
			Draw::SetStdFont(fntEnglish);
			Title(" English ");
			Lang = 0 ;
			break;
	}

	btnMenu1.SetLabel(btnLables[Lang][0]);
	btnMenu2.SetLabel(btnLables[Lang][1]);
	btnMenu3.SetLabel(btnLables[Lang][2]);
};

multilang::multilang()
{
	int i1 ;

	i1 = Font::FindFaceNameIndex("Lohit Kannada");
	fntKannada = Font(i1,20);
	btnKannada.SetFont(fntKannada);

//	fntMarathi = fntKannada ;
	
	i1 = Font::FindFaceNameIndex("Lohit Marathi");
	fntMarathi = Font(i1,20);
	btnMarathi.SetFont(fntMarathi);

	i1 = Font::FindFaceNameIndex("Arial");
	fntEnglish = Font(i1,20);
	btnEnglish.SetFont(fntEnglish);
	
	InitDisplay();
	Click(10);
};

GUI_APP_MAIN
{
	multilang().Run();
}

