#include "ManagedLib.h"
#using <mscorlib.dll>

__interface IMath 
{
	int Factorial(int f); 
	double SquareRoot(double s); 
}; 

class Compute : public IMath 
{
public:
	int Factorial(int f) 
	{
		int i, result = 1;
		for (i = 2; i <= f; ++i)
			result = result * i;
		return result;
	};

	double SquareRoot(double s)
	{
		return System::Math::Sqrt(s);
	}
};

int GetFactorial(int f)
{
	Compute *c = new Compute;
	return c->Factorial(f);
}

double GetSquareRoot(double s)
{
	Compute *c = new Compute;
	return c->SquareRoot(s);
}
