#include "Calculator.h"

App::App()
{
	CtrlLayout(*this, "Calculator");
	MinimizeBox();

	input.NullText("input");
	output.NullText("output");

	tab.Add("Hide");
	tab.Add("Error");
}

Calculator::Calculator()
{
	CtrlLayout(*this);

	input.NullText("input");
	output.NullText("output");
}

AppComposite::AppComposite()
{
	Title("Calculator (Composite)");
	MinimizeBox();
	SetRect(App::GetLayoutSize());

	tab.Add("Hide");
	tab.Add("Error");

	split.Vert(calc, tab);
	split.SetPos(10000 - (App::GetLayoutSize() - calc.GetLayoutSize()).cy * 10000 / App::GetLayoutSize().cy);
	Add(split.SizePos());
}

GUI_APP_MAIN
{
	Ctrl::GlobalBackPaint();
	ChStdSkin();

	App().Run();
	AppComposite().Run();
}
