# Recursive renaming of *.icpp to *.cpp files for specified directory
# Usage:
# cmake -P RenameFiles.cmake
# or
# cmake -DRENAME_PATH="SomePathWithFilesToRename" -P RenameFiles.cmake
# Note: -D options need to be specified before -P option, to apply.

cmake_minimum_required(VERSION 2.8)

if(NOT RENAME_PATH)
	# uppsrc directory by default
	set(RENAME_PATH uppsrc CACHE STRING "Directory with *.icpp files to rename" FORCE)
endif()

if(NOT EXISTS ${RENAME_PATH})
	message(FATAL_ERROR "Selected directory doesn't exists: ${RENAME_PATH}")
else()
	message("Selected directory: ${RENAME_PATH}")
endif()

file(GLOB_RECURSE FILE_LIST "${RENAME_PATH}/*.icpp")

list(LENGTH FILE_LIST files_count)

foreach(icppfile ${FILE_LIST})
	get_filename_component(filename ${icppfile} NAME_WE)
	get_filename_component(filepath ${icppfile} PATH)

	set(cppfile ${filepath}/${filename}.cpp)

	file(RENAME ${icppfile} ${cppfile})
endforeach()

if(${files_count} GREATER 0)
	message("Files renamed: " ${files_count})
else()
	message("No files to rename")
endif()
