# Build flags, just for reference. Not all of them needed.

if(BUILD_SHARED_LIBS)
	add_definitions(-DflagSHARED)
endif()

if(CMAKE_COMPILER_IS_GNUCC)
	add_definitions(-DflagGCC)
endif()

if(MSVC)
	add_definitions(-DflagMSC)
endif()

if(WIN32)
	add_definitions(-DflagWIN32)
endif()

if(UNIX OR APPLE)
	add_definitions(-DflagPOSIX)
endif()

if(CMAKE_SYSTEM MATCHES Linux)
	add_definitions(-DflagLINUX)
endif()

if(CMAKE_SYSTEM MATCHES BSD)
	add_definitions(-DflagBSD)
endif()

if(CMAKE_SYSTEM MATCHES FreeBSD)
	add_definitions(-DflagFREEBSD)
endif()

if(APPLE) # CMAKE_OSX_ARCHITECTURES
	add_definitions(-DflagOSX11)
endif()

if(UNIX OR APPLE)
	option(BUILD_WITHOUT_GTK "Build without GTK" FALSE)

	if(BUILD_WITHOUT_GTK)
		add_definitions(-DflagNOGTK)
	endif()
endif()

option(BUILD_WITH_RAINBOW "Build with RAINBOW" FALSE)

if(BUILD_WITH_RAINBOW)
	add_definitions(-DflagRAINBOW)

	set(RAINBOW_BACKENDS
		SKELETON
		WINALT
		WINGL
		LINUXFB
		SDLFB
		WINFB
	)

	if(NOT RAINBOW_BACKEND)
		if(UNIX OR APPLE)
			set(RAINBOW_BACKEND "LINUXFB" CACHE STRING "Choose the RAINBOW backend, options are: ${RAINBOW_BACKENDS}" FORCE)
		else()
			set(RAINBOW_BACKEND "WINFB" CACHE STRING "Choose the RAINBOW backend, options are: ${RAINBOW_BACKENDS}" FORCE)
		endif()
	else()
		set(RAINBOW_BACKEND_MATCH OFF)

		foreach(var ${RAINBOW_BACKENDS})
			if(var STREQUAL "${RAINBOW_BACKEND}")
				set(RAINBOW_BACKEND_MATCH ON)
				break()
			endif()
		endforeach()

		if(NOT RAINBOW_BACKEND_MATCH)
			message(FATAL_ERROR "Please, choose correct RAINBOW_BACKEND, options are: ${RAINBOW_BACKENDS}")
		endif()
	endif()

	add_definitions(-Dflag${RAINBOW_BACKEND})
endif()
