function(add_init_file init_file copied_file)
	# Copies init_file to binary directory and returns the path to copied_file
	set(input_file ${CMAKE_CURRENT_SOURCE_DIR}/${init_file})
	if(EXISTS "${input_file}")
		#set(output_file "${CMAKE_CURRENT_BINARY_DIR}/${init_file}.cpp")
		set(output_file "${CMAKE_CURRENT_SOURCE_DIR}/${init_file}.cpp")
		configure_file("${input_file}" "${output_file}" COPY_ONLY)
		set(${copied_file} ${output_file} PARENT_SCOPE)
	endif()
endfunction()

# -----------------------------------------------------------------------------

#	University of Illinois/NCSA
#	Open Source License
#
#	Copyright (c) 2003-2011 University of Illinois at Urbana-Champaign.
#	All rights reserved.
#
#	Developed by:
#
#			LLVM Team
#
#			University of Illinois at Urbana-Champaign
#
#			http://llvm.org
#
#	Permission is hereby granted, free of charge, to any person obtaining a copy of
#	this software and associated documentation files (the "Software"), to deal with
#	the Software without restriction, including without limitation the rights to
#	use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
#	of the Software, and to permit persons to whom the Software is furnished to do
#	so, subject to the following conditions:
#
#			* Redistributions of source code must retain the above copyright notice,
#				this list of conditions and the following disclaimers.
#
#			* Redistributions in binary form must reproduce the above copyright notice,
#				this list of conditions and the following disclaimers in the
#				documentation and/or other materials provided with the distribution.
#
#			* Neither the names of the LLVM Team, University of Illinois at
#				Urbana-Champaign, nor the names of its contributors may be used to
#				endorse or promote products derived from this Software without specific
#				prior written permission.
#
#	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
#	FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
#	CONTRIBUTORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS WITH THE
#	SOFTWARE.

# The llvm_replace_compiler_option function from llvm/cmake/modules/LLVMProcessSources.cmake
function(replace_compiler_option var old new)
  # Replaces a compiler option or switch `old' in `var' by `new'.
  # If `old' is not in `var', appends `new' to `var'.
  # Example: replace_compiler_option(CMAKE_CXX_FLAGS_RELEASE "-O3" "-O2")
  # If the option already is on the variable, don't add it:
  if( "${${var}}" MATCHES "(^| )${new}($| )" )
    set(n "")
  else()
    set(n "${new}")
  endif()
  if( "${${var}}" MATCHES "(^| )${old}($| )" )
    string( REGEX REPLACE "(^| )${old}($| )" " ${n} " ${var} "${${var}}" )
  else()
    set( ${var} "${${var}} ${n}" )
  endif()
  set( ${var} "${${var}}" PARENT_SCOPE )
endfunction()
