#ifndef _Countdown_Countdown_h
#define _Countdown_Countdown_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

class TimeInput : public EditString
{
	public:
	Value Format(const Value& q) const
	{
		//TimeInput::setTime(15,7);
		String mq = q.ToString();
		String rt = "";
		int sep = mq.Find(':');
		if (sep < 0)
		{ /* no : */
			int x = StrInt(mq);
			if (x < 0 || x > 23) return "00:00";
			if (mq.GetLength() == 1)
			{
				rt << "0" << mq << ":00";
				return rt;
			}
			rt << mq << ":00";
			return rt;
		}
		String x1 = mq.Mid(0,sep);
		String x2 = mq.Mid(sep);
		while ((sep = x1.Find(':')) != -1) x1.Remove(sep);
		while ((sep = x2.Find(':')) != -1) x2.Remove(sep);

		int hrs = StrInt(x1);
		int min = StrInt(x2);
		if (hrs < 0 || hrs > 23) x1 = "00";
		else if (x1.GetLength() == 1) x1.Insert(0,'0');

		if (min < 0 || min > 59)
		{
			rt << x1 << ":00";
			return rt;
		}
		if (x2.GetLength() == 1) x2.Insert(0,'0');
		rt << x1 << ":" << x2;
		return rt;
	}
	int Filter(int chr) const
	{ /* only accept digits and ':' */
		if(IsDigit(chr) || chr == ':') return chr;
		return 0;
	}
	void increaseMin(int x=1)
	{
		//text.ToString()
		//GetData().ToString()
		if (x<1 || x>59) return; // no action
		int sep;
		String content = GetData().ToString();
		if (content.GetLength() < 5 || (sep = content.Find(':',0)) < 0)
		{
			if (x<10) {
				content = "00:0";
				content << IntStr(x);
			} else
			{
				content = "00:";
				content = IntStr(x);
			}
			SetText(content);
			return;
		} else
		{
			int hour = StrInt(content.Mid(0,sep));
			int min = StrInt(content.Mid(sep+1)) + x;
			if (min > 59)
			{
				min -= 60;
				if (++hour>23) hour = 0;
			}
			setNewTime(hour,min);
			return;
		}
	}
	void decreaseMin(int x=1)
	{
		//text.ToString()
		//GetData().ToString()
		if (x<1 || x>59) return; // no action
		int sep;
		String content = GetData().ToString();
		if (content.GetLength() < 5 || (sep = content.Find(':',0)) < 0)
		{
			x = 60-x;
			if (x<10) {
				content = "23:0";
				content << IntStr(x);
			} else
			{
				content = "23:";
				content << IntStr(x);
			}
			SetText(content);
			return;
		} else
		{
			int hour = StrInt(content.Mid(0,sep));
			int min = StrInt(content.Mid(sep+1)) - x;
			if (min < 0)
			{
				min = 60+min;
				if (--hour<0) hour = 23;
			}
			setNewTime(hour,min);
			return;
		}
	}
	void increaseHour(int x=1)
	{
		//text.ToString()
		//GetData().ToString()
		if (x<1 || x>24) return; // no action
		int sep;
		String content = GetData().ToString();
		if (content.GetLength() < 5 || (sep = content.Find(':',0)) < 0)
		{
			if (x<10) {
				content = "0";
				content << IntStr(x);
			} else content = IntStr(x);
			content << ":00";
			SetText(content);
			return;
		} else
		{
			int hour = StrInt(content.Mid(0,sep)) + x;
			int min = StrInt(content.Mid(sep+1));
			while (hour > 23) hour -= 24;
			setNewTime(hour,min);
			return;
		}
	}
	void decreaseHour(int x=1)
	{
		//text.ToString()
		//GetData().ToString()
		if (x<1 || x>24) return; // no action
		int sep;
		String content = GetData().ToString();
		if (content.GetLength() < 5 || (sep = content.Find(':',0)) < 0)
		{
			x = 24 - x;
			if (x<10) {
				content = "0";
				content << IntStr(x) << ":00";
			} else
			{
				content = IntStr(x);
				content << ":00";
			}
			SetText(content);
			return;
		} else
		{
			int hour = StrInt(content.Mid(0,sep)) - x;
			int min = StrInt(content.Mid(sep+1));
			if (hour<0) hour += 24;
			setNewTime(hour,min);
			return;
		}
	}
	protected:
	void setNewTime(int& hour, int& min)
	{
		String content;
		if (hour < 10) content << "0";
		content << IntStr(hour) << ":";
		if (min < 10) content << "0";
		content << IntStr(min);
		SetText(content);
	}
};
typedef TimeInput EditTimeHM;

#define LAYOUTFILE <Countdown/Countdown.lay>
#include <CtrlCore/lay.h>

class Countdown : public WithCountdownLayout<TopWindow> {
public:
	typedef Countdown CLASSNAME;
	Countdown();
private:
	void UpdateClock();
	void btnHourClick();
	void btnMinClick();
	String leadZero(int&);
};

#endif
