#include "lance.h"

void lance::SecureClose()
{
	if (
		checkSettingsModify() &&
		PromptOKCancel("Save changes on settings tab or discard it?")
		)
	{ /* save changes */
		// ...
	}
	Close();
}
void lance::fillSettings()
{
	settings.title <<= "Initial title";
	settings.body <<= "Initial body...\nand more!";
	settings.title.ClearModify();
	settings.body.ClearModify();
}
bool lance::checkSettingsModify()
{
	if (settings.title.IsModified()) return true;
	if (settings.body.IsModified()) return true;
	return false;
}
void lance::tabChange()
{
	if (~settings.ask && lastIndex == settingsIndex && ~this->tab != settingsIndex)
	{ /* user has left settings tab and wants to be asked.. */
		if (checkSettingsModify())
		{
			if(PromptOKCancel("Save changes on settings tab or discard it?"))
			{ /* save them */
				// ...
			} else
			{ /* discard changes */
				fillSettings();
			}
			settings.title.ClearModify();
			settings.body.ClearModify();
		}
	}
	lastIndex = ~this->tab;
}

lance::lance()
{
	CtrlLayout(*this, "Window title");
	this->Sizeable().MaximizeBox();
	
	CtrlLayout(settings);
	CtrlLayout(stuff);
	CtrlLayout(info);
	
	this->tab.Add(settings, t_("Settings"));
	this->tab.Add(stuff, t_("Stuff"));
	this->tab.Add(info, t_("Info"));

	this->tab <<= THISBACK(tabChange);
	settingsIndex = this->tab.Find(settings);
	lastIndex = ~this->tab;
	settings.ask <<= true;
	
	fillSettings();
	
	this->WhenClose = THISBACK(SecureClose);
}

GUI_APP_MAIN
{
	lance().Run();
}
