#include "App.h"

TabTemplate::TabTemplate()
{
	CtrlLayout(*this);

	text.NullText("Null text");

	for (int i = 1; i <= 5; ++i)
		list.Add(AsString(i));

	slider.Range(50);
}

App::App()
{
	CtrlLayout(*this, "TabCtrl example");
	CenterScreen().Sizeable().MinimizeBox().MaximizeBox();

	WhenClose = THISBACK(OnClose);
	btnDefault.Tip(t_("Defaults for selected tab"));
	btnSave.Tip(t_("Saves values from tabs"));
	btnSave.WhenPush = THISBACK(OnSave);
	btnCancel.Tip(t_("Cancels values for tabs"));
	btnCancel.WhenPush = THISBACK(OnLoad);

	tab.Add(first.SizePos(), t_("First"));
	tab.Add(second.SizePos(), t_("Second"));
	tab.Add(third.SizePos(), t_("Third"));

	tab.WhenAction = THISBACK(OnTabAction);
	OnTabAction();

	options.SetCount(3);
}

void App::Serialize(Stream& s)
{
	SerializePlacement(s);

	for (int i = 0; i < 3; ++i)
		s % options[i].text %
			options[i].list %
			options[i].slider %
			options[i].option %
			options[i].toggle;
}

void App::FirstDefault()
{
	first.text <<= "first";
	first.list.SetIndex(0);
	first.slider <<= 10;
	first.option.Set(1);
	first.toggle <<= 0;
}

void App::SecondDefault()
{
	second.text <<= "second";
	second.list.SetIndex(1);
	second.slider <<= 20;
	second.toggle <<= 1;
}

void App::ThirdDefault()
{
	third.text <<= "third";
	third.list.SetIndex(2);
	third.slider <<= 30;
	third.option.Set(1);
	third.toggle <<= 2;
}

void App::FillTabs()
{
	FirstDefault();
	SecondDefault();
	ThirdDefault();

	OnSave();
}
// Events
void App::OnTabAction()
{
	switch(tab.Get()) {
	case 0: btnDefault.WhenAction = THISBACK(FirstDefault); break;
	case 1: btnDefault.WhenAction = THISBACK(SecondDefault); break;
	case 2: btnDefault.WhenAction = THISBACK(ThirdDefault); break;
	default:
		btnDefault.WhenAction = callback1(PromptOK, "No defaults");
	}
}

void App::OnSave()
{
	options[0].text = ~first.text;
	options[0].list = ~first.list;
	options[0].slider = ~first.slider;
	options[0].option = ~first.option;
	options[0].toggle = ~first.toggle;

	options[1].text = ~second.text;
	options[1].list = ~second.list;
	options[1].slider = ~second.slider;
	options[1].option = ~second.option;
	options[1].toggle = ~second.toggle;

	options[2].text = ~third.text;
	options[2].list = ~third.list;
	options[2].slider = ~third.slider;
	options[2].option = ~third.option;
	options[2].toggle = ~third.toggle;

	tab.ClearModify();
}

void App::OnLoad()
{
	first.text <<= options[0].text;
	first.list <<= options[0].list;
	first.slider <<= options[0].slider;
	first.option <<= options[0].option;
	first.toggle <<= options[0].toggle;

	second.text <<= options[1].text;
	second.list <<= options[1].list;
	second.slider <<= options[1].slider;
	second.option <<= options[1].option;
	second.toggle <<= options[1].toggle;

	third.text <<= options[2].text;
	third.list <<= options[2].list;
	third.slider <<= options[2].slider;
	third.option <<= options[2].option;
	third.toggle <<= options[2].toggle;

	tab.ClearModify();
}

void App::OnClose()
{
	if (tab.IsModified())
		if (PromptOKCancel("Do you want to save changes?") == IDOK)
			OnSave();
	Break();
}

GUI_APP_MAIN
{
	Ctrl::GlobalBackPaint();

	App app;
	const String config(ConfigFile());

	if (FileExists(config)) {
		LoadFromFile(app, ConfigFile());
		app.OnLoad();
	}
	else
		app.FillTabs();

	app.Run();

	StoreToFile(app, config);
}
