#include "App.h"

CompositeCtrl::CompositeCtrl()
{
	CtrlLayout(*this);

	slider.Range(100);

	for (int i = 1; i <= 10; ++i)
		list.Add(i);

	SizePos().NoWantFocus();
}

#ifndef flagSECOND
Value CompositeCtrl::GetData() const
{
	Data ctrl(~text, ~list, ~slider, ~option);

	return RawToValue(ctrl);
}

void CompositeCtrl::SetData(const Value& data)
{
	const Data& ctrl = ValueTo<Data>(data);
	text <<= ctrl.text;
	list <<= ctrl.list;
	slider <<= ctrl.slider;
	option <<= ctrl.option;
}
#endif
App::App()
{
	Title("ArrayCtrl with layout(s)");
	CenterScreen().Sizeable().MinimizeBox().MaximizeBox();
	const Size sz(640, 480);
	SetMinSize(sz); SetRect(sz);

	list.AutoHideSb();
	list.AddColumn("#").HeaderTab().Fixed(30);
	list.AddColumn("Composite").Ctrls<CompositeCtrl>();
	list.SetLineCy(CompositeCtrl::GetLayoutSize().cy);

	Add(list.HSizePosZ(4, 4).VSizePosZ(4, 4));
}

void App::FillWithData()
{
	list.Clear();

	for (int i = 0; i < 10; ++i)
	{
		const int count = i + 1;
#ifndef flagSECOND
		CompositeCtrl::Data data(FormatIntRoman(count, true), count, count * 10, count % 2 == 0);
		list.Add(count, RawToValue(data));
#else
		list.Add(count, Null);
		CompositeCtrl *ctrl = static_cast<CompositeCtrl *>(list.GetCtrl(i, 1));

		if (ctrl) {
			ctrl->text <<= FormatIntRoman(count, true);
			ctrl->list <<= count;
			ctrl->slider <<= count * 10;
			ctrl->option <<= count % 2 == 0;
		}
#endif
	}
}

GUI_APP_MAIN
{
	Ctrl::GlobalBackPaint();

	App app;
	app.FillWithData();
	app.Run();
}
