#include "SqlCtrlTest.h"

#include <Sql/sch_schema.h>
#include <Sql/sch_source.h>

#include "Class.h"
#include "Person.h"


SqlCtrlTest::SqlCtrlTest()
{
	CtrlLayout(*this, "Window title");


//// TAB 1 //////////////////////////////////////////////////////////////////////////////////////////////
	
		rectc.Add(ctrl_sqa_class.LeftPos(5, 500).TopPos(5, 200));
		rectc.Add(ctrl_btn_new_c.LeftPos(5, 90).TopPos(210, 20));			ctrl_btn_new_c.SetLabel("New class");
		rectc.Add(ctrl_btn_edit_c.LeftPos(100, 90).TopPos(210, 20));		ctrl_btn_edit_c.SetLabel("Edit class");
		rectc.Add(ctrl_btn_delete_c.LeftPos(195, 90).TopPos(210, 20));		ctrl_btn_delete_c.SetLabel("Delete class");
		
		ctrl_tab.Add(rectc.SizePos(), "Class");

		// Button events
		
			ctrl_btn_new_c <<= THISBACK(CreateClass);
			ctrl_btn_edit_c <<= THISBACK(EditClass);
			ctrl_btn_delete_c <<= THISBACK(RemoveClass);
			
			ctrl_sqa_class.WhenLeftDouble = THISBACK(EditClass);
			
		// Link database and control
		
			ctrl_sqa_class.SetTable(CLASS);
			
			ctrl_sqa_class.AddKey(IDCLASS);
			ctrl_sqa_class.AddColumn(LEVEL, "Level");
			ctrl_sqa_class.AddColumn(TITLE, "Title");
			ctrl_sqa_class.SetOrderBy(LEVEL, TITLE);
			
		// Load data from table
		
			ctrl_sqa_class.Query();
		
		
//// TAB 2 //////////////////////////////////////////////////////////////////////////////////////////////
	
		rectp.Add(ctrl_sqa_test.LeftPos(5, 500).TopPos(5, 200));
		rectp.Add(ctrl_btn_new.LeftPos(5, 50).TopPos(210, 20));			ctrl_btn_new.SetLabel("New");
		rectp.Add(ctrl_btn_edit.LeftPos(60, 50).TopPos(210, 20));		ctrl_btn_edit.SetLabel("Edit");
		rectp.Add(ctrl_btn_delete.LeftPos(115, 50).TopPos(210, 20));	ctrl_btn_delete.SetLabel("Delete");
		
		ctrl_tab.Add(rectp.SizePos(), "Person");

		// Button events
		
			ctrl_btn_new <<= THISBACK(Create);
			ctrl_btn_edit <<= THISBACK(Edit);
			ctrl_btn_delete <<= THISBACK(Remove);

		// Link database and control
			
			ctrl_sqa_test.SetTable(PERSON);
			ctrl_sqa_test.AddKey(ID);
			ctrl_sqa_test.AddColumn(NAME, "Name");
			ctrl_sqa_test.AddColumn(LASTNAME, "Last Name");
			ctrl_sqa_test.AddColumn(AGE, "Age");
			ctrl_sqa_test.SetOrderBy(IDC, NAME);			
	
		// control event
		
			ctrl_sqa_test.WhenLeftDouble = THISBACK(Edit);
				
		// Load data from table
			
			ctrl_sqa_test.Query();

}

/***************************************** CRUD CLASS ******************************************/

void SqlCtrlTest::CreateClass()
{
	ClassDlg dlg;
	
	if(dlg.Execute() != IDOK)
		return; // CANCEL or CLOSE

// Do sql query
	
	SQL * dlg.ctrls_class.Insert(CLASS);
	int id = SQL.GetInsertedId();
	
// Refresh main window

	ctrl_sqa_class.ReQuery();
    ctrl_sqa_class.FindSetCursor(id);
}

void SqlCtrlTest::EditClass()
{
	int id = ctrl_sqa_class.GetKey();

	if(IsNull(id))
		return;
	
// Load data having IDCLASS = id

	ClassDlg dlg;
	
	// Allow all
	dlg.ctrls_class.Enable();
	dlg.lblEnd.Hide();
	dlg.ok.Enable();
	
	dlg.ctrls_class.Load(CLASS, IDCLASS == id);
	
	if(dlg.Execute() != IDOK)
		return;	
	
// Update database

	SQL * dlg.ctrls_class.Update(CLASS).Where(IDCLASS == id);
	
// Update SqlArray Ctrl
	
	ctrl_sqa_class.ReQuery();	
}

void SqlCtrlTest::RemoveClass()
{
// Get ID and ask if user confirm to delete data

	int id = ctrl_sqa_class.GetKey();
	if(IsNull(id) || !PromptYesNo("Delete row?"))
		return;		
	
	SQL * SqlDelete(CLASS).Where(IDCLASS == id);
	
	ctrl_sqa_class.ReQuery();
}

/***************************************** CRUD PERSON ******************************************/

void SqlCtrlTest::Create()
{
	PersonDlg dlg;
		
	if(dlg.Execute() != IDOK)
		return; // CANCEL or CLOSE

// Do sql query 
// B. Using structures defined by schema files

	int idclass = dlg.title.GetIndex();
	
	S_PERSON p;
	p.IDC 		= (int) dlg.title.GetKey(idclass);
	p.NAME 		= (String) dlg.name.GetData();
	p.LASTNAME 	= (String) dlg.lastname.GetData();
	p.AGE 		= (int) dlg.age.GetData();
	
	SQL * Insert(p);
		
// Refresh main window

	int id = SQL.GetInsertedId();
	ctrl_sqa_test.ReQuery();
    ctrl_sqa_test.FindSetCursor(id);
}

void SqlCtrlTest::Edit()
{	
// Get ID

	int id = ctrl_sqa_test.GetKey();
	
	if(IsNull(id))
		return;
	
// Load data having ID into the dialog

	PersonDlg dlg;
	
	if(!dlg.ctrls_person.Load(PERSON, ID == id))
		return;

	S_PERSON p;
	SQL * Select(p).From(PERSON).Where(ID == id);
	if(SQL.Fetch(p)) 
	{				
		int nt = dlg.title.GetCount();
		
		for(int i=0; i<nt; i++)
		{
			if(	dlg.title.GetKey(i) == p.IDC )
			{
				dlg.title.SetIndex(i);
				break;
			}
		}				
	}
		
// Execute dialog
	
	if(dlg.Execute() != IDOK)
		return; // CANCEL or CLOSE
	
// Update changes
	
	//SQL * dlg.ctrls_person.Update(PERSON).Where(ID == id); will be fun but we need to update also IDC

	int idclass 	= dlg.title.GetIndex();
	
	p.ID		= id;
	p.IDC		= (int) dlg.title.GetKey(idclass);
	p.NAME 		= (String) dlg.name.GetData();
	p.LASTNAME 	= (String) dlg.lastname.GetData();
	p.AGE 		= (int) dlg.age.GetData();
	
	Sql sql;
	sql.Update(p);
	

// Refresh main window
	
	ctrl_sqa_test.ReQuery();
}

void SqlCtrlTest::Remove()
{
// Get ID and ask if user confirm to delete data

	int id = ctrl_sqa_test.GetKey();
	if(IsNull(id) || !PromptYesNo("Delete row?"))
		return;		
	
	SQL * SqlDelete(PERSON).Where(ID == id);
	ctrl_sqa_test.ReQuery();
}

/*************************************** MAIN ******************************************************/

GUI_APP_MAIN
{
	Sqlite3Session sqlite3;
	if(!sqlite3.Open(ConfigFile("persons.db"))) {
		LOG("Can't create or open database file\n");
		return;
	}
	sqlite3.SetTrace();
	
	SQL = sqlite3;
	
	// Update the schema to match the schema described in "Model.sch"
	// Permet de créer la base quand c'est la première fois qu'on lance le logiciel
	
	SqlSchema sch(SQLITE3);
	StdStatementExecutor se(sqlite3);
	All_Tables(sch);
	if(sch.ScriptChanged(SqlSchema::UPGRADE))
		Sqlite3PerformScript(sch.Upgrade(),se);
	if(sch.ScriptChanged(SqlSchema::ATTRIBUTES)) {
		Sqlite3PerformScript(sch.Attributes(),se);
	}
	if(sch.ScriptChanged(SqlSchema::CONFIG)) {
		Sqlite3PerformScript(sch.ConfigDrop(),se);
		Sqlite3PerformScript(sch.Config(),se);
	}
	sch.SaveNormal();


	SqlCtrlTest().Run();
}
