#ifndef _Jsonize_Jsonize_h_
#define _Jsonize_Jsonize_h_
#include <Core/Core.h>
using namespace Upp;

struct JsonIO
{
	JsonIO(bool isLoading = true);
	inline bool IsLoading() {return isLoading;}
	inline bool IsStoring() {return !isLoading;}
	
	template <class T> JsonIO & operator()(const char *key, T& var);

	enum Type
	{
		TYPE_ENTRY,
		TYPE_ARRAY,
		TYPE_MAP
	};
	void SetType(Type t) {type = t;}
	void SetPretty(bool b) {isPretty = b;}

	bool          isLoading;
	bool          isPretty;
	CParser      *parser;
	CParser::Pos  pos;
	ArrayMap<String,JsonIO> map;
	Array<JsonIO> array;
	
	String storingString;
	int    storingIndent;
	
	Type type;
};

template <class T> void Jsonize(JsonIO &json, T& var)
{
	var.Jsonize(json);
}

template<> void Jsonize(JsonIO &, String &var);
template<> void Jsonize(JsonIO &, int    &var);
template<> void Jsonize(JsonIO &, bool   &var);
template<> void Jsonize(JsonIO &, double &var);
template <class T> void Jsonize(JsonIO &, Vector<T> &var, const T &newT = T());
template <class T> void Jsonize(JsonIO &, Array<T> &var, const T &newT = T());
template <class T> void Jsonize(JsonIO &, VectorMap<String,T> &var, const T &newT = T());
template <class T> void Jsonize(JsonIO &, ArrayMap<String,T> &var, const T &newT = T());

#endif
