#ifndef _plugin_tif_tif_h_
#define _plugin_tif_tif_h_

#include <Draw/Draw.h>

struct tiff;

#if flagNOEXTLIB || flagWIN32
	#include "lib/tiff.h"
	#include "lib/tiffio.h"
	#include "lib/tiffiop.h"
#else
	#include <tiff.h>
	#include <tiffio.h>
#endif

#undef int8
#undef uint8
#undef int16
#undef uint16
#undef int32
#undef uint32

#undef HAVE_INT8
#undef HAVE_INT16
#undef HAVE_INT32
#undef HAVE_UINT8
#undef HAVE_UINT16
#undef HAVE_UINT32

NAMESPACE_UPP

struct tiff *TIFFStreamOpen(const char *filename, const char *mode, Stream *stream, bool destruct = false);
struct tiff *TIFFFileStreamOpen(const char *filename, const char *mode);

//struct tiff* TIFFWrapOpen(const char*, const char*);
//int TIFFWrapGetField(::tiff* tif_data, uint32 tag, ...);

class TIFRaster : public StreamRaster {
public:
	struct Data;
	One<Data> data;

public:
	TIFRaster();
	~TIFRaster();

	virtual bool                Create();
	virtual Size                GetSize();
	virtual Info                GetInfo();
	virtual Line                GetLine(int line);
	virtual int                 GetPaletteCount();
	virtual const RGBA         *GetPalette();
	virtual const RasterFormat *GetFormat();

	virtual int                 GetPageCount();
	virtual int                 GetActivePage() const;
	virtual void                SeekPage(int n);

private:
	bool                        Init();
};

class TIFEncoder : public StreamRasterEncoder {
public:
	class Data;
	One<Data> data;

public:
	TIFEncoder(int bpp = 24);
	~TIFEncoder();

	TIFEncoder&  Bpp(int b)       { bpp = b; return *this; }

	virtual int  GetPaletteCount();
	virtual void Start(Size sz);
	virtual void WriteLineRaw(const byte *s);

private:
	int bpp;
};

END_UPP_NAMESPACE

#endif
