#ifndef _AutoChoice_AutoChoice_h_
#define _AutoChoice_AutoChoice_h_

#include <CtrlLib/CtrlLib.h>

NAMESPACE_UPP

CtrlFrame& DropFrame();

class PopupTable : public ArrayCtrl {
public:
	virtual void Deactivate();
	virtual void LeftUp(Point p, dword keyflags);
	virtual void CancelMode();

protected:
	int          droplines;
	int          inpopup;
	bool         open;

public:
	void         PopUp(Ctrl *owner, int x, int top, int bottom, int width);
	void         PopUp(Ctrl *owner, int width);
	void         PopUp(Ctrl *owner);

	Callback     WhenCancel;
	Callback     WhenSelect;

	int			 GetDropLines()						{ return droplines; }
	PopupTable&  SetDropLines(int _droplines) 	{ droplines = _droplines; return *this; }

	bool		 IsOpen()							{ return open; }
	void         Normal();
	void         DoClose();
	
	PopupTable();
	virtual ~PopupTable();
};


template <class T>
class WithAutoChoice : public T {
public:
	virtual bool    Key(dword key, int repcnt);

protected:
	PopupTable    list;

public:
	void            ClearList()							{ list.Clear(); }
	void            AddList(const Value& data)			{ list.Add(data); }

	int             GetCount() const					{ return list.GetCount(); }
	Value           Get(int i) const					{ return list.Get(i); }
	
	void 			Select(bool select = true);
	void 			Drop();
	
	WithAutoChoice();
};

template <class T>
WithAutoChoice<T>::WithAutoChoice() {
	list.Normal();
}

template <class T>
bool WithAutoChoice<T>::Key(dword key, int repcnt) {
	if (list.IsOpen()) {
		int q = list.GetCursor();
		switch(key) {
			case K_ALT_DOWN:
				Drop();
				break;
			case K_TAB:
				Select(false);
				list.DoClose();
				list.WhenCancel();
				break;
			case K_ENTER:
				Select();
			case K_ESCAPE:
				list.DoClose();
				list.WhenCancel();
				return true;
			case K_DOWN:
				list.SetCursor(q < 0 || q >= list.GetCount() - 1 ? 0 : q + 1);
				return true;
			case K_UP:
				list.SetCursor(q <= 0 ? list.GetCount() - 1 : q - 1);
				return true;
			case K_PAGEDOWN:
				list.SetCursor(q < 0 || q >= list.GetCount() + list.GetDropLines() ? 0 : q + list.GetDropLines());
				return true;
			case K_PAGEUP:
				list.SetCursor(q <= 0 ? list.GetCount() - list.GetDropLines() : q - list.GetDropLines());
				return true;
		}
	}
	else {
		if (key == K_ALT_DOWN)
			Drop();
	}
	//return select.Key(key, repcnt) || T::Key(key, repcnt);
	bool result = T::Key(key, repcnt);

	if (IsAlNum(key)) {
		String s = T::GetData().ToString();
		for(int i = 0; i < list.GetCount(); i++) {
			if (ToLower(list.Get(i, 0).ToString()).StartsWith(ToLower(s))) {
				Drop();
				list.SetCursor(i);
				break;
			}
		}
	}
	
	return result;
}

template <class T>
void WithAutoChoice<T>::Select(bool select) {
	if (list.IsCursor()) {
		Value l = list.Get(0);
		Value e = T::GetData();
		if (l.IsVoid()) return;
		if (select) {
			T::SetData(l);
			T::WhenAction();
		}
	}
}

template <class T>
void WithAutoChoice<T>::Drop() {
	if(!list.FindSetCursor(T::GetData()) && list.GetCount() > 0)
		list.SetCursor(0);
	if (! list.IsOpen()) list.PopUp(this);
}

END_UPP_NAMESPACE

#endif
