#ifndef _TabCtrlExample_App_h
#define _TabCtrlExample_App_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define LAYOUTFILE <TabCtrlExample/TabLayout.lay>
#include <CtrlCore/lay.h>

#include "CtrlBinder.h"

class TabTemplate : public WithTemplateLayout<ParentCtrl> {
public:
	typedef TabTemplate CLASSNAME;
	TabTemplate();
};

struct Options : Moveable<Options> {
	String text;
	Value list;
	int slider;
	bool option;
	int toggle;
};

class App : public WithTabLayout<TopWindow> {
public:
	typedef App CLASSNAME;
	App();
	void Serialize(Stream& s);

	CtrlBinder manager;
	Array<TabTemplate> inset;
	Vector<Options> options;

	void BindCtrls();
	void FirstDefault();
	void SecondDefault();
	void ThirdDefault();
	void FillTabs();
	// Events
	void OnTabAction();
	void OnSave();
	void OnLoad();
	void OnClose();
};

#endif
