#ifndef _CtrlBinder_h_
#define _CtrlBinder_h_

class CtrlBinder {
//	Based on CtrlRetriever implementation.
//	Main difference: CtrlBinder doesn't assign value to Ctrl, during the binding, by default. There is Assign method for this.
//	Therefore, CtrlBinder could be used in either direction - to assign or retrieve values.
public:
	struct Item {
		virtual void Assign() = 0;
		virtual void Retrieve() = 0;
		virtual ~Item() {}
	};

private:
	struct CtrlItem0 : Item {
		Ctrl  *ctrl;
	};

	template <class T>
	struct CtrlItem : CtrlItem0 {
		T     *value;

		virtual void Assign()    { *ctrl <<= *value; }
		virtual void Retrieve()  { *value = ~*ctrl; }
		virtual ~CtrlItem() {}
	};

protected:
	Array<Item> item;

public:
	void Put(Item *newitem)      { item.Add(newitem); }

	template <class T>
	void Bind(Ctrl& ctrl, T& val, bool assign = false);

	template <class T>
	CtrlBinder& operator()(Ctrl& ctrl, T& val, bool assign = false) {
		Bind(ctrl, val, assign); return *this;
	}

	void Assign();
	void Retrieve();

	Callback operator<<=(Callback cb);
};

template <class T>
void CtrlBinder::Bind(Ctrl& ctrl, T& val, bool assign)
{
	CtrlItem<T> *m = new CtrlItem<T>();
	m->ctrl = &ctrl;
	m->value = &val;
	if (assign)
		ctrl <<= val;
	Put(m);
}

Callback CtrlBinder::operator<<=(Callback cb)
{
	for(int i = 0; i < item.GetCount(); i++) {
		CtrlItem0 *m = dynamic_cast<CtrlItem0 *>(&item[i]);
		if(m)
			m->ctrl->WhenAction = cb;
	}
	return cb;
}

void CtrlBinder::Assign()
{
	for(int i = 0; i < item.GetCount(); i++)
		item[i].Assign();
}

void CtrlBinder::Retrieve()
{
	for(int i = 0; i < item.GetCount(); i++)
		item[i].Retrieve();
}

#endif
