#include "App.h"

TabTemplate::TabTemplate()
{
	CtrlLayout(*this);

	text.NullText("Null text");

	for (int i = 1; i <= 5; ++i)
		list.Add(AsString(i));

	slider.Range(50);
}

App::App()
{
	CtrlLayout(*this, "TabCtrl example");
	CenterScreen().Sizeable().MinimizeBox().MaximizeBox();

	WhenClose = THISBACK(OnClose);
	btnDefault.Tip(t_("Defaults for selected tab"));
	btnSave.Tip(t_("Saves values from tabs"));
	btnSave.WhenPush = THISBACK(OnSave);
	btnCancel.Tip(t_("Cancels values for tabs"));
	btnCancel.WhenPush = THISBACK(OnLoad);

	inset.SetCount(3);
	options.SetCount(3);

	tab.Add(inset[0].SizePos(), t_("First"));
	tab.Add(inset[1].SizePos(), t_("Second"));
	tab.Add(inset[2].SizePos(), t_("Third"));

	tab.WhenAction = THISBACK(OnTabAction);
	OnTabAction();

	BindCtrls();
}

void App::Serialize(Stream& s)
{
	SerializePlacement(s);

	for (int i = 0; i < 3; ++i)
		s % options[i].text %
			options[i].list %
			options[i].slider %
			options[i].option %
			options[i].toggle;
}

void App::BindCtrls()
{
	for(int i = 0; i < 3; ++i)
		manager
			(inset[i].text, options[i].text)
			(inset[i].list, options[i].list)
			(inset[i].slider, options[i].slider)
			(inset[i].option, options[i].option)
			(inset[i].toggle, options[i].toggle);
}

void App::FirstDefault()
{
	inset[0].text <<= "first";
	inset[0].list.SetIndex(0);
	inset[0].slider <<= 10;
	inset[0].option.Set(1);
	inset[0].toggle <<= 0;
}

void App::SecondDefault()
{
	inset[1].text <<= "second";
	inset[1].list.SetIndex(1);
	inset[1].slider <<= 20;
	inset[1].option.Set(0);
	inset[1].toggle <<= 1;
}

void App::ThirdDefault()
{
	inset[2].text <<= "third";
	inset[2].list.SetIndex(2);
	inset[2].slider <<= 30;
	inset[2].option.Set(1);
	inset[2].toggle <<= 2;
}

void App::FillTabs()
{
	FirstDefault();
	SecondDefault();
	ThirdDefault();

	OnSave();
}
// Events
void App::OnTabAction()
{
	switch(tab.Get()) {
	case 0: btnDefault.WhenAction = THISBACK(FirstDefault); break;
	case 1: btnDefault.WhenAction = THISBACK(SecondDefault); break;
	case 2: btnDefault.WhenAction = THISBACK(ThirdDefault); break;
	default:
		btnDefault.WhenAction = callback1(PromptOK, t_("No defaults"));
	}
}

void App::OnSave()
{
	manager.Retrieve();
	tab.ClearModify();
}

void App::OnLoad()
{
	manager.Assign();
	tab.ClearModify();
}

void App::OnClose()
{
	if (tab.IsModified())
		if (PromptOKCancel(t_("Do you want to save changes?")) == IDOK)
			OnSave();
	Break();
}

GUI_APP_MAIN
{
	Ctrl::GlobalBackPaint();

	App app;
	const String config(ConfigFile());

	if (FileExists(config)) {
		LoadFromFile(app, config);
		app.OnLoad();
	}
	else
		app.FillTabs();

	app.Run();

	StoreToFile(app, config);
}
