#include "WRA.h"

#include "GoogleMaps.h"


void MapDlgDlg::SetHome()
{
	Size sz = map.GetSize();
	
//	map.home = GoogleMapsGpsToPixel(center, ~zoom, Size(640,640), home);
	map.home = GoogleMapsGpsToPixel(center, ~zoom, sz, home);

	gpsy.SetLabel("  " + FormatGPSY(home.y));
	gpsx.SetLabel("  " + FormatGPSX(home.x));
	map.Refresh();
}

void MapDlgDlg::LoadMap()
{
	Size sz = map.GetSize();

	map.map = GetGoogleMapImage(center.x, center.y, ~zoom, sz.cx, sz.cy, "png", &map.error);
//	map.map = GetGoogleMapImage(center.x, center.y, ~zoom, 640, 640, "png", &map.error);
	SetHome();
}

void MapDlgDlg::Move(int x, int y)
{
	center = GoogleMapsPixelToGps(center, ~zoom, Point(250 * x, 250 * y));
	LoadMap();
}

void MapDlgDlg::MapClick(Point p)
{
	Size sz = map.GetSize();

	home = GoogleMapsPixelToGps(center, ~zoom, sz, p);
//	home = GoogleMapsPixelToGps(center, ~zoom, Size(640,640), p);

	SetHome();
}

void MapDlgDlg::Set(Pointf p)
{
	home = center = p;
	LoadMap();
}

void MapDlgDlg::ZoomIn()
{
	zoom <<= min((int)~zoom + 1, 21);
	LoadMap();
}

void MapDlgDlg::ZoomOut()
{
	zoom <<= max((int)~zoom - 1, 0);
	LoadMap();	
}

MapDlgDlg::MapDlgDlg()
{
	CtrlLayoutOKCancel(*this, "");
	Icon(WRAImg::MainIcon());
	SizePos();
	Zoomable();
	Sizeable();
	
	Size sz = GetSize();
	Size msz = map.GetSize();
	sz += Size(640 - msz.cx, 640 - msz.cy);
	SetRect(sz);

	for(int i = 0; i < 22; i++)
		zoom.Add(i);	
	zoom <<= 17;
	zoom <<= THISBACK(LoadMap);
	zoomin <<= THISBACK(ZoomIn);
	zoomout <<= THISBACK(ZoomOut);
	
	left <<= THISBACK2(Move, -1, 0);
	left.SetImage(CtrlImg::SmallLeft());
	right <<= THISBACK2(Move, 1, 0);
	right.SetImage(CtrlImg::SmallRight());
	up <<= THISBACK2(Move, 0, -1);
	up.SetImage(CtrlImg::SmallUp());
	down <<= THISBACK2(Move, 0, 1);
	down.SetImage(CtrlImg::SmallDown());
	
	map.WhenLeftClick = THISBACK(MapClick);
}
/*
bool MapDlg(Pointf& p)
{
	MapDlgDlg dlg;
	dlg.Set(p);
	
	if(dlg.Run() == IDOK) {
		p = dlg.Get();
		return true;
	}
	return false;
}

void MapDlgAsThread(Pointf& p)
{
	MapDlgDlg dlg;
	dlg.Set(p);
	
	dlg.Execute();
	
	return;
	
	if(dlg.Execute() == IDOK) {
		p = dlg.Get();
		return;
	}
	return;
}
*/

void MapDlgDlg::MouseWheel(Point p, int zdelta, dword keyflags)
{
	{
		if(zdelta>0) // zoom in
		{
			ZoomIn();			
		}
		else if(zdelta<0) // zoom out
		{
			ZoomOut();
		}
	}	
}

bool MapImage::Key(dword key,int count)
{
	switch(key) // del key down
	{
		case K_UP:
		{
			((MapDlgDlg*)GetParent())->Move(0,-1);
			break;
		}
		case K_DOWN:
		{
			((MapDlgDlg*)GetParent())->Move(0,1);
			break;
		}
		case K_RIGHT:
		{
			((MapDlgDlg*)GetParent())->Move(1,0);
			break;
		}
		case K_LEFT:
		{
			((MapDlgDlg*)GetParent())->Move(-1,0);
			break;
		}
	}
	return true;
}

void MapImage::Paint(Draw& w) 
{
	static Size szOld(0,0);
	Size sz = GetSize();
	
	if(sz!=szOld && szOld!=Size(0,0))
	{
		((MapDlgDlg*)GetParent())->LoadMap();			
	}
	
	w.DrawRect(sz, SColorPaper());
	if(IsNull(map))
		w.DrawText(0, 0, error);
	else 
	{
		w.DrawImage(0, 0, map);
		Point p = WRAImg::Pin().GetHotSpot();
		w.DrawImage(home.x - p.x, home.y - p.y, WRAImg::Pin());
	}
	
	szOld=sz;
}	

